/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.RoleException;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.HqlUtil;
import com.cenqua.crucible.view.ReviewFilters;
import com.cenqua.crucible.view.RowDetail;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewManager {
    public static final Role AUTHOR = new Role("Author", 1);
    public static final Role MODERATOR = new Role("Moderator", 2);
    public static final Role REVIEWER = new Role("Reviewer", 3);
    public static final Role CREATOR = new Role("Creator", 4);
    private static final String CREATOR_MATCH = ":user = review.creator";
    private static final String AUTHOR_MATCH = "(:user = p.ruc.user and p.author = true)";
    private static final String MODERATOR_MATCH = "(:user = p.ruc.user and p.moderator = true)";
    private static final String REVIEWER_MATCH = "(:user = p.ruc.user and p.reviewer = true)";
    public static final String PERMAID_KEY_PATTERN = "([A-Za-z0-9\\-]+)";
    public static final String PERMAID_PATTERN = "([A-Za-z0-9\\-]+)-(\\d+)";
    public static final Pattern PERMAID_PROG = Pattern.compile("([A-Za-z0-9\\-]+)-(\\d+)");

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static Review createReviewWithDefaults(ProjectManager projectManager, Project project, String name) throws DbException {
        Review review = ReviewManager.createReview(projectManager, project, name);
        if (project.getDefaultModerator() != null) {
            review.setModerator(project.getDefaultModerator());
        }
        if (project.getDefaultRepositoryName() != null) {
            review.setRepoName(project.getDefaultRepositoryName());
        }
        Set<CrucibleUser> reviewers = project.getDefaultReviewers();
        for (CrucibleUser reviewer : reviewers) {
            review.addReviewer(reviewer);
        }
        review.setAllowReviewerToJoin(project.isAllowReviewersToJoin());
        return review;
    }

    public static Review createReview(ProjectManager projectManager, Project project, String name) {
        Review review = new Review(projectManager, project, name);
        ReviewManager.session().save((Object)review);
        LogManager.logStateChange(review.getStateName(), review.getId());
        LogManager.log("Review: " + review.getId() + " " + name + " created.");
        review.setMetricsVersion(MetricsManager.INSTANCE.getLatestVersion());
        return review;
    }

    public static Collection<Review> getReviews() {
        String[] states = new String[]{StateManager.INSTANCE.getDeadState().getName()};
        return ReviewManager.getReviewsInState(null, states, false, "review");
    }

    private static String getRoleMatchString(Role role) throws RoleException {
        if (role == AUTHOR) {
            return AUTHOR_MATCH;
        }
        if (role == MODERATOR) {
            return MODERATOR_MATCH;
        }
        if (role == REVIEWER) {
            return REVIEWER_MATCH;
        }
        if (role == CREATOR) {
            return CREATOR_MATCH;
        }
        throw new RoleException("Role " + role + " is not defined");
    }

    public static Collection getReviewIdsAsRoleInState(CrucibleUser user, Role role, String state) throws RoleException {
        return ReviewManager.getReviewsAsRoleInState(user, role, state, "review.id");
    }

    private static Collection getReviewsAsRoleInState(CrucibleUser user, Role role, String state, String selector) throws RoleException {
        String match = ReviewManager.getRoleMatchString(role);
        String qstr = "select " + selector + " " + "from Review review " + (role == CREATOR ? "" : "join review.participants p ") + "where review.stateName = :state " + "and " + match;
        Query q = ReviewManager.session().createQuery(qstr);
        q.setEntity("user", (Object)user);
        q.setString("state", state);
        return q.list();
    }

    public static List getReviewsAllReviewersComplete(String selector, String grouper) {
        String qstr = "select " + selector + " from ReviewParticipant p, Review review " + "where review.stateName = 'Review' " + "and review.id = p.ruc.review " + "and (select count(sp.ruc.review) " + "from ReviewParticipant sp " + "where sp.ruc.review = review.id " + "and sp.allComplete = false and sp.reviewer = true) = 0 " + (grouper != null ? " group by " + grouper : "");
        Query q = ReviewManager.session().createQuery(qstr);
        return q.list();
    }

    private static String[] convertStatesToStrings(State[] states) {
        String[] names = new String[states.length];
        int i2 = 0;
        for (State s : states) {
            names[i2++] = s.toString();
        }
        return names;
    }

    public static List<Review> getVisibleReviews(Principal viewer, ReviewFilters.FilterDef f2, String title, String grouper) {
        List allReviews = ReviewManager.getReviewsAsRolesInStates(f2, title, "review", grouper);
        ArrayList<Review> visibleReviews = new ArrayList<Review>();
        for (Review r : allReviews) {
            if (!ReviewUtil.principalCanDoReviewAction(viewer, "action:viewReview", r)) continue;
            visibleReviews.add(r);
        }
        return visibleReviews;
    }

    public static int countVisibleReviews(Principal viewer, ReviewFilters.FilterDef filter) {
        return HqlUtil.getCountFromSet(ReviewManager.getReviewsAsRolesInStates(filter, null, "count(distinct review.id)", null)).intValue();
    }

    public static List getReviewsAsRolesInStates(ReviewFilters.FilterDef f2, String title, String selector, String grouper) {
        String roleLogic;
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(f2.state, true);
        String userMatch = f2.author != null ? "( auth.author = true and auth.user = :auth " : null;
        String string = roleLogic = f2.orRoles ? "or" : "and";
        if (f2.moderator != null) {
            userMatch = userMatch != null ? userMatch + roleLogic + " mod.moderator = true and mod.user = :mod " : "( mod.moderator = true and mod.user = :mod ";
        }
        if (f2.creator != null) {
            userMatch = userMatch != null ? userMatch + roleLogic + " review.creator = :creator " : "( review.creator = :creator ";
        }
        if (f2.reviewer != null) {
            String completeTest = f2.complete != null ? " and rev.allComplete = " + f2.complete : "";
            userMatch = userMatch != null ? userMatch + roleLogic + " rev.reviewer = true and rev.user = :rev" + completeTest : "( rev.reviewer = true and rev.user = :rev" + completeTest;
        }
        if (userMatch != null) {
            userMatch = userMatch + " )";
        }
        String titleMatch = StringUtil.nullOrEmpty(title) ? null : "review.name like :title";
        String projectMatch = f2.project == null ? null : "proj.key = :project";
        String qstr = "select " + selector + " " + "from Review review " + (f2.author != null ? "join review.participants auth " : "") + (f2.moderator != null ? "join review.participants mod " : "") + (f2.reviewer != null ? "join review.participants rev " : "") + (f2.project != null ? "join review.project proj " : "");
        String where = HqlUtil.whereBuilder("", stateFrag, "and");
        where = HqlUtil.whereBuilder(where, userMatch, "and");
        where = HqlUtil.whereBuilder(where, titleMatch, "and");
        where = HqlUtil.whereBuilder(where, projectMatch, "and");
        qstr = qstr + where + (grouper != null ? " group by " + grouper : "");
        Query q = ReviewManager.session().createQuery(qstr);
        if (f2.author != null) {
            q.setEntity("auth", (Object)f2.author);
        }
        if (f2.moderator != null) {
            q.setEntity("mod", (Object)f2.moderator);
        }
        if (f2.creator != null) {
            q.setEntity("creator", (Object)f2.creator);
        }
        if (f2.reviewer != null) {
            q.setEntity("rev", (Object)f2.reviewer);
        }
        if (!StringUtil.nullOrEmpty(title)) {
            q.setString("title", "%" + title + "%");
        }
        if (f2.project != null) {
            q.setString("project", f2.project.getKey());
        }
        List results = q.list();
        if (f2.allReviewersComplete != null) {
            List l = ReviewManager.getReviewsAllReviewersComplete(selector, grouper);
            if (f2.allReviewersComplete.booleanValue()) {
                results.retainAll(l);
            } else {
                results.removeAll(l);
            }
        }
        return results;
    }

    public static Set searchReviewForTerm(String term, String selector, String grouper) {
        Review r = null;
        Matcher m = PERMAID_PROG.matcher(term);
        if (m.matches()) {
            PermaIdKey permaKey = new PermaIdKey(m.group(1), Integer.parseInt(m.group(2)));
            r = ReviewManager.getReviewByPermaId(permaKey);
        }
        term = term.toLowerCase(Locale.US);
        String qstr = "select " + selector + " " + "from Review review " + "where lower(review.name) like :name " + "or lower(review.description) like :desc " + (StateManager.INSTANCE.isStateName(term) ? "or review.stateName = '" + StateManager.INSTANCE.getStateByName(term).getName() + "' " : "") + (r != null ? "or review.id = " + r.getId() : "") + "and review.stateName <> '" + StateManager.INSTANCE.getDeadState().getName() + "' " + (grouper != null ? "group by " + grouper : "");
        try {
            Query q = ReviewManager.session().createQuery(qstr);
            q.setString("name", "%" + term + "%");
            q.setString("desc", "%" + term + "%");
            HashSet results = new HashSet();
            results.addAll(q.list());
            results.addAll(ReviewManager.searchReviewProject(term, selector, grouper));
            return results;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2);
            return null;
        }
    }

    public static List searchReviewProject(String term, String selector, String grouper) {
        String qstr = "select " + selector + " " + "from Review review join review.project proj " + "where " + "lower(proj.key) like :term " + (grouper != null ? "group by " + grouper : "");
        Query q = ReviewManager.session().createQuery(qstr);
        q.setString("term", "%" + term + "%");
        return q.list();
    }

    public static long countStatesOn(Date date, String state, Project project) {
        String qstr = "select count(log) from StateChangeLog log, Review review where log.timeStamp < :date and review.id = log.reviewId and review.project = :project and (select count(log2.id) from StateChangeLog log2 where log2.reviewId = log.reviewId and log2.timeStamp < :date and log2.id > log.id) = 0 and log.newState = :state ";
        Query q = ReviewManager.session().createQuery(qstr);
        q.setTimestamp("date", date);
        q.setEntity("project", (Object)project);
        q.setString("state", state);
        long n = (Long)q.uniqueResult();
        return n;
    }

    public static void processLogRecords(Date from, Date to, Project project, LogRecordProcessor processor) {
        String qstr = "select log from StateChangeLog log, Review review where log.timeStamp < :to and (log.superseded = null or log.superseded > :from) and review.id = log.reviewId and review.project = :project order by log.reviewId, log.timeStamp";
        Query q = ReviewManager.session().createQuery(qstr);
        q.setTimestamp("to", to);
        q.setTimestamp("from", from);
        q.setEntity("project", (Object)project);
        for (StateChangeLog log : q.list()) {
            processor.handle(log);
        }
        processor.afterFinalRecord();
    }

    public static Collection<Review> getReviewsInStates(String[] states) {
        return ReviewManager.getReviewsInState(null, states, true, "review");
    }

    public static Collection<Review> getReviewsInStates(Project project, String[] states) {
        return ReviewManager.getReviewsInState(project, states, true, "review");
    }

    private static Collection<Review> getReviewsInState(Project project, String[] states, boolean inState, String selector) {
        if (states.length == 0) {
            return null;
        }
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        if (project != null) {
            stateFrag = HqlUtil.whereBuilder(stateFrag, "review.project = :project", "and");
        }
        Query q = ReviewManager.session().createQuery("select " + selector + " from Review review " + (stateFrag == null ? "" : "where " + stateFrag));
        if (project != null) {
            q.setEntity("project", (Object)project);
        }
        return Collections.checkedCollection(new LinkedList(q.list()), Review.class);
    }

    private static String makeSelectReviewsByStateFrag(String[] states, boolean inState) {
        if (states == null || states.length == 0) {
            return null;
        }
        String cond = inState ? "=" : "<>";
        String logic = inState ? "or" : "and";
        String qstr = "(review.stateName " + cond + " '" + states[0] + "' ";
        for (int i2 = 1; i2 < states.length; ++i2) {
            String state = states[i2];
            qstr = qstr + logic + " review.stateName " + cond + " '" + state + "' ";
        }
        return qstr + ")";
    }

    private static List getReviewRowDetail(int start, int length, String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        String qstr = "select review.id, review.name, review.description, review.createDate, review.stateName, review.creator from Review review " + (stateFrag == null ? "" : "where " + stateFrag + " ") + "order by review.id";
        Query q = ReviewManager.session().createQuery(qstr);
        if (length != 0) {
            q.setFirstResult(start);
            q.setMaxResults(length);
        }
        return q.list();
    }

    public static List getReviewAuthorModerators(String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        String qstr = "select review.id, p1.user, p2.user from Review review join review.participants p1 join review.participants p2 where " + (stateFrag == null ? "" : stateFrag + " and ") + "p1.author = true and p2.moderator = true " + "order by review.id";
        Query q = ReviewManager.session().createQuery(qstr);
        return q.list();
    }

    public static List getReviewPermaIds(String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        String qstr = "select review.id, rpid.permaIdKey.key, rpid.permaIdKey.number from Review review join review.project p, ReviewPermaId rpid where " + (stateFrag == null ? "" : stateFrag + " and ") + "rpid.review = review and p.key = rpid.permaIdKey.key " + "order by review.id";
        Query q = ReviewManager.session().createQuery(qstr);
        return q.list();
    }

    public static List getReviewCompletedReviewersCount(String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        Query q = ReviewManager.session().createQuery("select review.id, count(p) from Review review join review.participants p where " + (stateFrag == null ? "" : stateFrag + " and ") + "p.reviewer = true and p.allComplete = true " + "group by review.id");
        return q.list();
    }

    public static List getReviewActiveReviewersCount(String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        Query q = ReviewManager.session().createQuery("select review.id, count(p) from Review review join review.participants p where " + (stateFrag == null ? "" : stateFrag + " and ") + "p.reviewer = true and p.allComplete = false " + "group by review.id");
        return q.list();
    }

    public static List getReviewCommentCount(String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        Query q = ReviewManager.session().createQuery("select review.id, count(comment.id) from Review review join review.comments comment where " + (stateFrag == null ? "" : stateFrag + " and ") + "comment.deleted = false and comment.draft = false " + "group by review.id");
        return q.list();
    }

    public static int countReviewsInStateContainingFileRevision(String[] states, FileRevision fr) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, true);
        Query q = ReviewManager.session().createQuery("select count(distinct review) from Review review join review.frxs frx where " + (stateFrag == null ? "" : stateFrag + " and ") + "frx.frr.fileRevision = :fr");
        q.setEntity("fr", (Object)fr);
        Number result = (Number)q.uniqueResult();
        return result.intValue();
    }

    public static List getReviewFrxsCommentCount(String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        Query q = ReviewManager.session().createQuery("select review.id, count(distinct rc.comment.id) from Review review join review.frxs frx join frx.revisionComments rc where " + (stateFrag == null ? "" : stateFrag + " and ") + "rc.comment.deleted = false and rc.comment.draft = false " + "group by review.id");
        return q.list();
    }

    private static List<Review> getReviews(String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        Query q = ReviewManager.session().createQuery("select review from Review review " + (stateFrag == null ? "" : "where " + stateFrag));
        return q.list();
    }

    private static List getReviewAndFrxCount(String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        Query q = ReviewManager.session().createQuery("select frx.review.id, count(frx) from Review review, FileRevisionExtraInfo frx where frx.review.id = review.id" + (stateFrag == null ? "" : "and " + stateFrag) + " group by frx.review.id");
        return q.list();
    }

    public static int countReviewsCreatedInPeriod(Date startDate, Date endDate, Project project) {
        Query q = ReviewManager.session().createQuery("select count(review) from Review review where review.project = :project and review.createDate > :startDate and review.createDate <= :endDate and review.stateName != :deadState and review.stateName != :draftState");
        q.setEntity("project", (Object)project);
        q.setTimestamp("startDate", startDate);
        q.setTimestamp("endDate", endDate);
        q.setString("deadState", StateManager.INSTANCE.getDeadState().getName());
        q.setString("draftState", StateManager.INSTANCE.getDraftState().getName());
        return ((Long)q.uniqueResult()).intValue();
    }

    public static List getReviewChildren(Review parent) {
        return ReviewManager.getReviewChildren(parent, new String[]{StateManager.INSTANCE.getDeadState().getName()}, false);
    }

    public static List getReviewChildren(Review parent, String[] states, boolean inState) {
        String stateFrag = ReviewManager.makeSelectReviewsByStateFrag(states, inState);
        Query q = ReviewManager.session().createQuery("select review from Review review where " + (stateFrag == null ? "" : stateFrag + " and ") + "review.parentReview = :parent");
        q.setEntity("parent", (Object)parent);
        return q.list();
    }

    public static Review getReviewById(int id) {
        return ReviewManager.getReviewById(new Integer(id));
    }

    public static Review getReviewByPermaId(String permaId) throws PermaIdFormatException {
        if (permaId == null) {
            throw new PermaIdFormatException("Null Review PermaId");
        }
        Matcher m = PERMAID_PROG.matcher(permaId);
        if (m.matches()) {
            PermaIdKey permaKey = new PermaIdKey(m.group(1), Integer.parseInt(m.group(2)));
            return ReviewManager.getReviewByPermaId(permaKey);
        }
        throw new PermaIdFormatException(permaId + " is an invalid Review PermaId");
    }

    public static Review getReviewByPermaId(PermaIdKey permaKey) {
        Query q = ReviewManager.session().createQuery("select rpid.review from ReviewPermaId rpid where lower(rpid.permaIdKey.key) = :key and rpid.permaIdKey.number = :number");
        q.setString("key", permaKey.getKey().toLowerCase(Locale.US));
        q.setInteger("number", permaKey.getNumber());
        return (Review)q.uniqueResult();
    }

    public static Review getReviewById(Integer id) {
        return (Review)ReviewManager.session().get(Review.class, (Serializable)id);
    }

    public static Review getById(Integer id) {
        return ReviewManager.getReviewById(id);
    }

    public static LinkedHashMap<Integer, RowDetail> getReviewDetailsMap() {
        LinkedHashMap<Integer, RowDetail> reviewDetails = new LinkedHashMap<Integer, RowDetail>();
        List details = ReviewManager.getReviewRowDetail(0, 0, null, true);
        for (Object detail : details) {
            Object[] objects = (Object[])detail;
            RowDetail rd = new RowDetail(objects);
            reviewDetails.put(rd.getId(), rd);
        }
        List permaIds = ReviewManager.getReviewPermaIds(null, true);
        for (Object permaId : permaIds) {
            Object[] objects = (Object[])permaId;
            RowDetail rd = (RowDetail)reviewDetails.get((Integer)objects[0]);
            rd.setPermaId(objects[1] + "-" + objects[2]);
        }
        List authmod = ReviewManager.getReviewAuthorModerators(null, true);
        for (Object anAuthmod : authmod) {
            Object[] objects = (Object[])anAuthmod;
            RowDetail rd = (RowDetail)reviewDetails.get((Integer)objects[0]);
            rd.setAuthor((CrucibleUser)objects[1]);
            rd.setModerator((CrucibleUser)objects[2]);
        }
        List activeCount = ReviewManager.getReviewActiveReviewersCount(null, true);
        for (Object anActiveCount : activeCount) {
            Object[] objects = (Object[])anActiveCount;
            ((RowDetail)reviewDetails.get((Integer)objects[0])).setActiveCount((Long)objects[1]);
        }
        List completedCount = ReviewManager.getReviewCompletedReviewersCount(null, true);
        for (Object aCompletedCount : completedCount) {
            Object[] objects = (Object[])aCompletedCount;
            ((RowDetail)reviewDetails.get((Integer)objects[0])).setCompletedCount((Long)objects[1]);
        }
        List reviews = ReviewManager.getReviewAndFrxCount(null, true);
        for (Object[] review : reviews) {
            ((RowDetail)reviewDetails.get((Integer)review[0])).setFileCount((Long)review[1]);
        }
        List comments = ReviewManager.getReviewCommentCount(null, true);
        for (Object comment : comments) {
            Object[] objects = (Object[])comment;
            reviewDetails.get((Integer)objects[0]).setReviewCommentCount((Long)objects[1]);
        }
        List frxComments = ReviewManager.getReviewFrxsCommentCount(null, true);
        for (Object frxComment : frxComments) {
            Object[] objects = (Object[])frxComment;
            reviewDetails.get((Integer)objects[0]).setFileCommentCount((Long)objects[1]);
        }
        return reviewDetails;
    }
}

