/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.StringUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class GeneralNotification
extends Notification {
    private static final String GENERAL_NOTE_TEMPLATE = "general-notification.ftl";

    public GeneralNotification() {
    }

    public GeneralNotification(CrucibleUser actioner, Review review, String note) {
        super(actioner);
        this.setReview(review);
        this.setNote(note);
    }

    protected Integer getType() {
        return NotificationManager.TYPE_GENERAL;
    }

    public String getLink() {
        return AppConfig.getsConfig().getSiteURL() + "cru/" + this.getReview().getPermaId();
    }

    protected String getEmailTemplateName() {
        return GENERAL_NOTE_TEMPLATE;
    }

    public String getRSSNote() throws IOException, TemplateException {
        return this.getEmailNote();
    }

    public String getRSSTitle() {
        return this.getReview().getPermaId() + ": Note";
    }

    public String getDescription() {
        return StringUtil.firstLineOf(this.getNote(), 40, false, true, true);
    }

    public List getRolesToNotify() {
        LinkedList<Role> roles = new LinkedList<Role>();
        roles.add(ReviewManager.AUTHOR);
        roles.add(ReviewManager.MODERATOR);
        roles.add(ReviewManager.REVIEWER);
        roles.add(ReviewManager.CREATOR);
        return roles;
    }

    public Integer getEmailNotificationPref(CrucibleUser user) {
        return user.getGeneralEmailNotification();
    }

    public Integer getRssNotificationPref(CrucibleUser user) {
        return user.getCompleteEmailNotification();
    }
}

