/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.notification;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.notification.DeliverySchedule;
import com.cenqua.crucible.notification.Notification;
import com.cenqua.crucible.notification.NotificationStore;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.MailMessage;
import com.cenqua.fisheye.mail.Mailer;
import freemarker.template.TemplateException;
import java.io.IOException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class Recipient {
    private Integer id;
    private NotificationStore note = null;
    private CrucibleUser user = null;
    private Integer email = null;
    private Integer rss = null;
    private Boolean uiACK = null;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    private NotificationStore getNoteStore() {
        return this.note;
    }

    private void setNoteStore(NotificationStore note) {
        this.note = note;
    }

    public Notification getNotification() {
        return (Notification)this.note;
    }

    public void setNotification(Notification notification) {
        this.note = notification;
    }

    public CrucibleUser getUser() {
        return this.user;
    }

    public void setUser(CrucibleUser user) {
        this.user = user;
    }

    public Integer getEmail() {
        return this.email;
    }

    public void setEmail(Integer email) {
        this.email = email;
    }

    public Integer getRss() {
        return this.rss;
    }

    public void setRss(Integer rss) {
        this.rss = rss;
    }

    public Boolean getUiACK() {
        return this.uiACK;
    }

    public void setUiACK(Boolean uiACK) {
        this.uiACK = uiACK;
    }

    public synchronized void emailNotification() {
        if (this.user.isActive() && this.user.getEmail() != null) {
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)("Notifying user [" + this.user.getUserName() + "]"));
            }
            this.email = DeliverySchedule.SENT;
            Notification note = this.getNotification();
            MailMessage msg = new MailMessage();
            msg.addRecipient(this.user.getEmail());
            msg.setSubject("[" + AppConfig.getProductName() + "]" + note.getEmailSubject());
            msg.overrideFromDisplayName(note.getActioner().getDisplayName());
            try {
                msg.setFrom(new InternetAddress(note.getActioner().getEmailStr()));
                msg.setBodyText("text/plain; charset=UTF-8", note.getEmailNote());
                Mailer mailer = AppConfig.getsConfig().getMailer();
                mailer.sendMessage(msg);
            }
            catch (TemplateException e2) {
                Logs.APP_LOG.error((Object)"Error in template", (Throwable)e2);
            }
            catch (AddressException e3) {
                Logs.APP_LOG.error((Object)("Error parsing address '" + note.getActioner().getEmail() + "'"), (Throwable)e3);
            }
            catch (IOException e4) {
                Logs.APP_LOG.error((Object)"Email template file not found", (Throwable)e4);
            }
        }
    }
}

