/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.reports.reviews;

import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.DateHelper;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeries;

public class ReviewsDatasetMaker {
    private DefaultTableXYDataset reviewDataSet;
    private Period period = new Period();
    private String stateName;
    private Project project;
    private long maxReviews;
    private long openReviews;

    public ReviewsDatasetMaker() {
        this.period.lastWeek();
        this.stateName = "Review";
        this.maxReviews = 0L;
        this.openReviews = 0L;
    }

    public ReviewsDatasetMaker(Date from, Date to, String stateName, Project project) {
        this.period.setTo(DateHelper.getEndOfDay(to, AppConfig.getsConfig().getTimezone()));
        this.period.setFrom(DateHelper.getStartOfDay(from, AppConfig.getsConfig().getTimezone()));
        this.stateName = stateName;
        this.project = project;
    }

    public TableXYDataset getDataSet() {
        if (this.reviewDataSet == null) {
            this.makeDataset(6);
        }
        return this.reviewDataSet;
    }

    private void makeDataset(int interval) {
        GregorianCalendar cal = new GregorianCalendar();
        this.reviewDataSet = new DefaultTableXYDataset();
        XYSeries s1 = new XYSeries((Comparable)((Object)this.stateName), true, false);
        int i2 = 0;
        cal.setTime(this.period.getFrom());
        while (this.period.getTo().compareTo(cal.getTime()) > 0) {
            long count = ReviewManager.countStatesOn(cal.getTime(), this.stateName, this.project);
            s1.add((double)i2++, (double)count);
            if (count > this.maxReviews) {
                this.maxReviews = count;
            }
            this.openReviews = count;
            cal.add(interval, 1);
        }
        this.reviewDataSet.addSeries(s1);
    }

    public long getMaxReviews() {
        return this.maxReviews;
    }

    public long getOpenReviews() {
        return this.openReviews;
    }
}

