/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.revision.diff.unified;

import com.cenqua.crucible.revision.diff.unified.DiffMatcher;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffException;
import com.cenqua.crucible.revision.diff.unified.UnifiedDiffListener;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.ReaderLineReader;
import java.io.IOException;

public class UnifiedDiffParser {
    private ReaderLineReader reader;
    private UnifiedDiffListener listener;
    private DiffMatcher diffMatcher = new DiffMatcher();

    private boolean findPath(String path) throws IOException {
        String line;
        path = path.replaceAll("^(/*|\\\\*)", "");
        while ((line = this.reader.readLine()) != null) {
            DiffMatcher.Header toHeader;
            String nextLine;
            DiffMatcher.Header fromHeader = this.diffMatcher.matchHeader(true, line);
            if (fromHeader == null || (nextLine = this.reader.readLine()) == null || (toHeader = this.diffMatcher.matchHeader(false, nextLine)) == null || !path.equals(fromHeader.getPath().replaceAll("^(/*|\\\\*)", "")) && !path.equals(toHeader.getPath().replaceAll("^(/*|\\\\*)", ""))) continue;
            this.processFromHeader(fromHeader);
            this.processToHeader(toHeader);
            return true;
        }
        return false;
    }

    public void processRevision(ReaderLineReader reader, UnifiedDiffListener listener, String path) throws UnifiedDiffException {
        this.reader = reader;
        this.listener = listener;
        try {
            String line;
            boolean found = this.findPath(path);
            while (found && (line = reader.readLine()) != null) {
                DiffMatcher.Section s;
                while (line != null && (s = this.diffMatcher.matchSection(line)) != null) {
                    line = this.processSection(s, this.diffMatcher);
                }
                if (line != null && this.diffMatcher.matchHeader(true, line) == null) continue;
                found = false;
            }
        }
        catch (Exception e2) {
            throw new UnifiedDiffException("Problem reading diff", e2);
        }
    }

    private void processFromHeader(DiffMatcher.Header header) {
        this.listener.fromFile(new Path(header.getPath()));
        this.listener.fromTimeStamp(header.getRevision());
    }

    private void processToHeader(DiffMatcher.Header header) {
        this.listener.toFile(new Path(header.getPath()));
        this.listener.toTimeStamp(header.getRevision());
    }

    private String processSection(DiffMatcher.Section section, DiffMatcher diffMatcher) throws IOException {
        String line;
        int fromLine = Integer.parseInt(section.getFromLine());
        int numFromLines = section.getNumberFromLines() == null ? 0 : Integer.parseInt(section.getNumberFromLines());
        int toLine = Integer.parseInt(section.getToLine());
        int numToLines = section.getNumberToLines() == null ? 0 : Integer.parseInt(section.getNumberToLines());
        this.listener.section(fromLine, numFromLines, toLine, numToLines);
        block6: while ((line = this.reader.readLine()) != null) {
            DiffMatcher.Header h2 = diffMatcher.matchHeader(true, line);
            if (h2 != null) {
                return line;
            }
            switch (line.charAt(0)) {
                case '+': {
                    this.listener.addLine(line.substring(1));
                    continue block6;
                }
                case '-': {
                    this.listener.removeLine(line.substring(1));
                    continue block6;
                }
                case ' ': {
                    this.listener.contextLine(line.substring(1));
                    continue block6;
                }
                case '\\': {
                    continue block6;
                }
            }
            return line;
        }
        return line;
    }
}

