/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.CustomField;
import com.cenqua.crucible.model.Review;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class CommentDO {
    protected Comment comment;
    private String message;
    private CrucibleUser currentUser;

    public CommentDO(Comment comment, CrucibleUser user) {
        this.comment = comment;
        this.message = comment.getMessage();
        this.currentUser = user;
    }

    public boolean isDraft() {
        return this.comment.isDraft();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Comment getComment() {
        return this.comment;
    }

    public Review getReview() {
        return this.comment.getReview();
    }

    public Integer getId() {
        return this.comment.getId();
    }

    public CrucibleUser getUser() {
        return this.comment.getUser();
    }

    public String getCommentColor() {
        return "annotAuth" + this.getUser().getId() % 100;
    }

    public Date getCreateDate() {
        return this.comment.getCreateDate();
    }

    public List getVisibleComments() {
        LinkedList<Comment> visComments = new LinkedList<Comment>();
        for (Comment reply : this.comment.getComments()) {
            if (reply.isDeleted() || reply.isDraft() && !reply.getUser().equals(this.currentUser)) continue;
            visComments.add(reply);
        }
        Collections.sort(visComments, new OldestFirstComparator());
        return visComments;
    }

    public int getCount() {
        return this.comment.getCommentCount();
    }

    public boolean isNegative() {
        return this.comment.isNegative();
    }

    public boolean isPositive() {
        return this.comment.isPositive();
    }

    public boolean isDefectRaised() {
        return this.comment.isDefectRaised();
    }

    public String getDefectStatus() {
        return this.comment.isDefectApproved() ? "approved" : "pending approval";
    }

    public String getMetricRank() {
        CustomField field = this.comment.getFieldByName("rank");
        return field != null ? field.getHrValue() : null;
    }

    public String getMetricClassification() {
        CustomField field = this.comment.getFieldByName("classification");
        return field != null ? field.getHrValue() : null;
    }

    public static class OldestFirstComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Comment a2 = (Comment)o1;
            Comment b2 = (Comment)o2;
            return a2.getCreateDate().compareTo(b2.getCreateDate());
        }
    }
}

