/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.view;

import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.StateManager;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewFilters {
    private CrucibleUser user;
    private Project project;
    public static final String ALL_REVIEWS = "allReviews";
    public static final String ALL_OPEN_REVIEWS = "allOpenReviews";
    public static final String ALL_CLOSED_REVIEWS = "allClosedReviews";
    public static final String ALL_DRAFT_REVIEWS = "draftReviews";
    public static final String TO_REVIEW = "toReview";
    public static final String REQUIRE_MY_APPROVAL = "requireMyApproval";
    public static final String TO_SUMMARIZE = "toSummarize";
    public static final String OUT_FOR_REVIEW = "outForReview";
    public static final String MY_DRAFT = "drafts";
    public static final String MY_OPEN = "open";
    public static final String MY_CLOSED = "closed";
    public static final String MY_TRASH = "trash";
    public static final String CUSTOM = "custom";
    private final StateManager stateMgr = StateManager.INSTANCE;

    public ReviewFilters(CrucibleUser user) {
        this.user = user;
    }

    public ReviewFilters(Project project) {
        this.project = project;
    }

    public CrucibleUser getUser() {
        return this.user;
    }

    public void setUser(CrucibleUser user) {
        this.user = user;
    }

    public List<FilterDef> getFilterDefsByKey(String key) {
        LinkedList<FilterDef> filters = new LinkedList<FilterDef>();
        if (ALL_REVIEWS.equals(key)) {
            filters.add(this.getAllReviewsFilterDef());
        }
        if (ALL_OPEN_REVIEWS.equals(key)) {
            filters.add(this.getAllOpenReviewsFilterDef());
        }
        if (ALL_CLOSED_REVIEWS.equals(key)) {
            filters.add(this.getAllClosedReviewsFilterDef());
        }
        if (ALL_DRAFT_REVIEWS.equals(key)) {
            filters.add(this.getAllDraftReviewsFilterDef());
        }
        if (TO_REVIEW.equals(key)) {
            filters.add(this.getToReviewFilterDef());
        }
        if (REQUIRE_MY_APPROVAL.equals(key)) {
            filters.add(this.getRequireMyApprovalFilterDef());
        }
        if (TO_SUMMARIZE.equals(key)) {
            filters.add(this.getToSummarizeFilterDef());
        }
        if (OUT_FOR_REVIEW.equals(key)) {
            filters.add(this.getAuthorModeratorInProgressFilterDef());
            filters.add(this.getAuthorInProgressFilterDef());
        }
        if (MY_DRAFT.equals(key)) {
            filters.add(this.getAllMyDraftReviewsFilterDef());
        }
        if (MY_OPEN.equals(key)) {
            filters.add(this.getAllMyOpenReviewsFilterDef());
            filters.add(this.getRequireMyApprovalFilterDef());
            filters.add(this.getAllMyDraftReviewsFilterDef());
        }
        if (MY_CLOSED.equals(key)) {
            filters.add(this.getAllMyClosedReviewsFilterDef());
        }
        if (MY_TRASH.equals(key)) {
            filters.add(this.getMyTrashedReviewsFilterDef());
        }
        if (CUSTOM.equals(key)) {
            filters.add(this.getCustomFilterDef());
        }
        return filters;
    }

    public FilterDef makeFilter() {
        return new FilterDef();
    }

    public FilterDef getAllReviewsFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.state = StateManager.INSTANCE.getNotDeadStateNames();
        f2.filterName = "All Reviews";
        f2.project = this.project;
        return f2;
    }

    public FilterDef getAllDraftReviewsFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.state = new String[]{this.stateMgr.getDraftState().getName()};
        f2.filterDescription = "All Draft reviews";
        f2.filterName = "Drafts";
        f2.project = this.project;
        return f2;
    }

    public FilterDef getAllOpenReviewsFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.state = StateManager.INSTANCE.getOpenStateNames();
        f2.filterName = "All Open Reviews";
        f2.project = this.project;
        return f2;
    }

    public FilterDef getAllClosedReviewsFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.state = StateManager.INSTANCE.getClosedStateNames();
        f2.filterName = "All Closed Reviews";
        f2.project = this.project;
        return f2;
    }

    public FilterDef getToReviewFilterDef() {
        FilterDef f2 = this.makeFilter();
        f2.state = new String[]{this.stateMgr.getReviewState().getName()};
        f2.filterName = "To Review";
        f2.filterDescription = "Reviews you need to do as reviewer";
        f2.reviewer = this.user;
        f2.complete = Boolean.FALSE;
        f2.project = this.project;
        return f2;
    }

    public FilterDef getRequireMyApprovalFilterDef() {
        FilterDef f2 = this.makeFilter();
        f2.state = new String[]{this.stateMgr.getApprovalState().getName()};
        f2.filterName = "Require My Approval";
        f2.filterDescription = "Reviews awaiting my approval as moderator";
        f2.moderator = this.user;
        f2.project = this.project;
        return f2;
    }

    public FilterDef getToSummarizeFilterDef() {
        FilterDef f2 = this.makeFilter();
        f2.state = new String[]{this.stateMgr.getReviewState().getName()};
        f2.filterName = "To Summarize";
        f2.filterDescription = "Reviews that need summarizing as moderator";
        f2.moderator = this.user;
        f2.allReviewersComplete = Boolean.TRUE;
        f2.project = this.project;
        return f2;
    }

    public FilterDef getAuthorModeratorInProgressFilterDef() {
        FilterDef f2 = this.makeFilter();
        f2.state = new String[]{this.stateMgr.getReviewState().getName()};
        f2.filterName = "Out For Review";
        f2.filterDescription = "Reviews that are in progress but don't require your immediate action";
        f2.moderator = this.user;
        f2.author = this.user;
        f2.orRoles = true;
        f2.allReviewersComplete = Boolean.FALSE;
        f2.project = this.project;
        return f2;
    }

    public FilterDef getAuthorInProgressFilterDef() {
        FilterDef f2 = this.makeFilter();
        f2.state = new String[]{this.stateMgr.getApprovalState().getName()};
        f2.filterName = "Out For Review";
        f2.filterDescription = "Reviews that are in progress";
        f2.author = this.user;
        f2.allReviewersComplete = Boolean.FALSE;
        f2.project = this.project;
        return f2;
    }

    public FilterDef getAllMyDraftReviewsFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.state = new String[]{this.stateMgr.getDraftState().getName()};
        f2.filterDescription = "My draft reviews";
        f2.filterName = "Drafts";
        f2.creator = this.user;
        f2.project = this.project;
        return f2;
    }

    public FilterDef getAllMyOpenReviewsFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.state = this.stateMgr.getOpenStateNames();
        f2.filterName = "Open";
        f2.filterDescription = "Open reviews I am involed in";
        f2.author = this.user;
        f2.moderator = this.user;
        f2.creator = this.user;
        f2.reviewer = this.user;
        f2.orRoles = true;
        f2.project = this.project;
        return f2;
    }

    public FilterDef getAllMyClosedReviewsFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.state = this.stateMgr.getClosedStateNames();
        f2.filterName = "Closed";
        f2.filterDescription = "Closed Reviews I Participated In";
        f2.author = this.user;
        f2.moderator = this.user;
        f2.creator = this.user;
        f2.reviewer = this.user;
        f2.orRoles = true;
        f2.project = this.project;
        return f2;
    }

    public FilterDef getCustomFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.filterName = "Custom Filter";
        return f2;
    }

    public FilterDef getMyTrashedReviewsFilterDef() {
        FilterDef f2 = new FilterDef();
        f2.state = new String[]{this.stateMgr.getDeadState().getName()};
        f2.filterDescription = "My trash";
        f2.filterName = "Trash";
        f2.creator = this.user;
        f2.project = this.project;
        return f2;
    }

    public class FilterDef {
        public String[] state;
        public CrucibleUser author;
        public CrucibleUser moderator;
        public CrucibleUser creator;
        public CrucibleUser reviewer;
        public Boolean complete;
        public Boolean allReviewersComplete;
        public String filterName;
        public String filterDescription;
        public Project project;
        public boolean orRoles = false;
    }
}

