/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.crucible.fisheye.CrucibleBridgeImplementation;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.crucible.CrucibleBridge;
import com.cenqua.fisheye.ctl.ShutdownService;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.web.WebServer;
import com.cenqua.obfuscate.idbk4ui8v._AndOrSpace;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import org.apache.velocity.app.Velocity;

public class AppConfig {
    private static File configurationFile;
    private static File sAppHome;
    private static File sInstanceHome;
    private static CrucibleBridge crucibleBridge;
    private static WebServer webServer;
    private static ShutdownService shutdown;
    private static boolean testMode;
    public static int DEFAULT_TAB_WIDTH;
    public static boolean noSlurp;
    public static final int MINICHART_WIDTH = 300;
    public static final int MINICHART_HEIGHT = 220;
    public static final int BIGCHART_WIDTH = 700;
    public static final int BIGCHART_HEIGHT = 400;
    public static final long START_TIME;
    private static long lastModified;

    public static void setTestMode() {
        testMode = true;
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static RootConfig getsConfig() {
        return RootConfigLazySingleton.sConfig;
    }

    public static void resetConfig(RootConfig c2) {
        RootConfigLazySingleton.sConfig = c2;
    }

    public static boolean isCrucible() {
        return FisheyeVersionInfo.CRUCIBLE_MODE;
    }

    public static void setWebServer(WebServer ws) {
        webServer = ws;
    }

    public static WebServer getWebServer() {
        return webServer;
    }

    public static ShutdownService getShutdown() {
        return shutdown;
    }

    public static void setShutdown(ShutdownService shutdown) {
        AppConfig.shutdown = shutdown;
    }

    public static String getProductName() {
        if (AppConfig.isCrucible()) {
            return "Crucible";
        }
        return "FishEye";
    }

    public static CrucibleBridge getCrucibleBridge() {
        return crucibleBridge;
    }

    public static long getLastModified() {
        return lastModified;
    }

    public static void updateLastModified() {
        lastModified = System.currentTimeMillis();
    }

    public static File getDataDir() {
        return new File(AppConfig.getVarDir(), "data");
    }

    public static File getVarDir() {
        return new File(AppConfig.getInstanceDir(), "var");
    }

    public static File getLogDir() {
        return new File(AppConfig.getVarDir(), "log");
    }

    public static File getTempDir() {
        return new File(AppConfig.getVarDir(), "tmp");
    }

    public static File getWebAppLocation() {
        return new File(AppConfig.getAppHome(), "content");
    }

    public static File getAppHome() {
        if (sAppHome == null) {
            String apphome = System.getProperty("fisheye.home");
            sAppHome = apphome != null ? new File(apphome).getAbsoluteFile() : new File(".").getAbsoluteFile();
        }
        return sAppHome;
    }

    public static File getInstanceDir() {
        if (sInstanceHome == null) {
            String instanceHome = System.getProperty("fisheye.inst");
            sInstanceHome = instanceHome != null ? new File(instanceHome) : AppConfig.getAppHome();
        }
        return sInstanceHome;
    }

    public static void overrideAppHome(File appHome, File instHome) {
        sAppHome = appHome;
        sInstanceHome = instHome;
    }

    public static File getConfigurationFile() {
        if (configurationFile == null) {
            configurationFile = new File(AppConfig.getInstanceDir(), "config.xml").getAbsoluteFile();
        }
        return configurationFile;
    }

    public static void setConfigurationFile(File cf) {
        configurationFile = cf;
    }

    static {
        testMode = false;
        DEFAULT_TAB_WIDTH = 8;
        noSlurp = false;
        try {
            Toolkit.getDefaultToolkit();
            GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        catch (Throwable e2) {
            Logs.APP_LOG.warn((Object)"Problem initing graphics environment, images may not render", e2);
        }
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        _Cu.setPoolSize(0);
        _AndOrSpace.enableCommonSubexpressionCache(false);
        if (FisheyeVersionInfo.CRUCIBLE_MODE) {
            crucibleBridge = new CrucibleBridgeImplementation();
        }
        lastModified = START_TIME = System.currentTimeMillis();
    }

    public static class Hacks {
        public static boolean DISABLE_DIRTREE_EMPTY_CHECKS = false;
        public static boolean DISABLE_CONTENT_INDEXING = false;
    }

    private static class RootConfigLazySingleton {
        static RootConfig sConfig = new RootConfig();

        private RootConfigLazySingleton() {
        }
    }
}

