/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.api;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.api.BaseApiHandler;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.cvsrep.search.SearchResults;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.cvsrep.search.query.ReturnClause;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ApiImplementation {
    public static final String CMD_LOGIN = "login";
    public static final String CMD_LOGOUT = "logout";
    public static final String CMD_LISTREPS = "listRepositories";
    public static final String CMD_LISTPATHS = "listPaths";
    public static final String CMD_LISTPATHHISTORY = "listPathHistory";
    public static final String CMD_GETREV = "getRevision";
    public static final String CMD_GETCHANGESET = "getChangeset";
    public static final String CMD_LISTCHANGESETS = "listChangesets";
    public static final String CMD_GETCSBOUNDS = "getChangesetBounds";
    public static final String CMD_QUERY = "query";
    public static final String CMD_LISTREVTAGS = "listTagsForRevision";
    public static final String CMD_FE_VERSION = "fisheyeVersion";
    public static final String CMD_CRU_VERSION = "crucibleVersion";
    private static final int MAX_MAX_RETURN = 3000;
    private final BaseApiHandler api;
    private RevisionCache mDB;
    private UserLogin mUser = null;

    public ApiImplementation(BaseApiHandler api) {
        this.api = api;
    }

    private boolean hasErrors() {
        return !this.api.getErrors().isEmpty();
    }

    private boolean handleErrors() throws IOException {
        if (!this.hasErrors()) {
            return false;
        }
        List errors = this.api.getErrors();
        StringBuffer buf = new StringBuffer();
        for (String msg : errors) {
            buf.append(msg).append("\n");
        }
        this.api.sendError(buf.toString());
        return true;
    }

    private String getRequiredStringParam(int pos, String name) {
        String v = this.api.getStringParam(pos, name);
        if (v == null) {
            this.api.addError("parameter '" + name + "' required but missing (argument number " + (pos + 1) + ").");
        }
        return v;
    }

    private Long getRequiredLongParam(int pos, String name) {
        Long value = this.api.getLongParam(pos, name);
        if (value == null) {
            this.api.addError("parameter '" + name + "' required but missing (argument number " + (pos + 1) + ").");
        }
        return value;
    }

    private RepositoryEngine getRepositoryParam(int pos, String name) throws IOException {
        String repName = this.getRequiredStringParam(pos, name);
        if (this.hasErrors()) {
            return null;
        }
        try {
            RepositoryHandle h2 = AppConfig.getsConfig().getRepositoryManager().getRepository(repName);
            if (h2 == null) {
                this.api.addError("unknown repository: " + repName);
                return null;
            }
            if (!this.accessAllowed(h2)) {
                this.api.addError("permission denied for: " + repName);
                return null;
            }
            RepositoryEngine rcfg = h2.acquireEngine();
            this.mDB = rcfg.getRevisionCache();
            return rcfg;
        }
        catch (RepositoryHandle.StateException e2) {
            this.api.addError("repository not in correct state: " + e2.getMessage());
            return null;
        }
    }

    private void getAuthTokenParam() {
        BaseApiHandler.Context context = this.api.getContext();
        String authString = this.api.getStringParam(0, "auth");
        if (!StringUtil.nullOrEmpty(authString)) {
            try {
                this.mUser = context.checkAuth(authString);
                if (this.mUser == null) {
                    this.api.addError("Given auth token not valid");
                }
            }
            catch (DbException e2) {
                this.api.addError("Internal error with login");
                Logs.APP_LOG.warn((Object)"problem logging in user", (Throwable)e2);
            }
        } else if (context.getUser() != null) {
            this.mUser = context.getUser();
        } else {
            RootConfig cfg = AppConfig.getsConfig();
            if (!cfg.getConfig().getSecurity().getAllowAnon()) {
                this.api.addError("anon access forbidden");
            }
        }
    }

    public void handle() throws IOException {
        RootConfig cfg = AppConfig.getsConfig();
        if (!cfg.isApiEnabled()) {
            this.api.sendError("API access is disabled");
            return;
        }
        String cmd = this.api.parseCommand();
        if (this.handleErrors()) {
            return;
        }
        if (cmd == null) {
            this.api.sendError("Error determining command");
            return;
        }
        this.handleCommand(cmd);
    }

    private void handleCommand(String command) throws IOException {
        if (CMD_LISTPATHHISTORY.equalsIgnoreCase(command)) {
            this.doListPathHistory();
        } else if (CMD_GETREV.equalsIgnoreCase(command)) {
            this.doGetRevision();
        } else if (CMD_LISTREVTAGS.equalsIgnoreCase(command)) {
            this.doListTagsRevision();
        } else if (CMD_LISTCHANGESETS.equalsIgnoreCase(command)) {
            this.doListChangesets();
        } else if (CMD_GETCHANGESET.equalsIgnoreCase(command)) {
            this.doGetChangeset();
        } else if (CMD_LISTREPS.equalsIgnoreCase(command)) {
            this.doListRepositories();
        } else if (CMD_LISTPATHS.equalsIgnoreCase(command)) {
            this.doListPaths();
        } else if (CMD_QUERY.equalsIgnoreCase(command)) {
            this.doQuery();
        } else if (CMD_FE_VERSION.equalsIgnoreCase(command)) {
            this.doFishEyeVersion();
        } else if (CMD_CRU_VERSION.equalsIgnoreCase(command)) {
            this.doCrucibleVersion();
        } else if (CMD_LOGIN.equalsIgnoreCase(command)) {
            this.doLogin();
        } else if (CMD_LOGOUT.equalsIgnoreCase(command)) {
            this.doLogout();
        } else {
            this.api.sendError("unknown command " + command);
        }
    }

    private void doQuery() throws IOException {
        this.getAuthTokenParam();
        RepositoryEngine rep = this.getRepositoryParam(1, "rep");
        String query = this.getRequiredStringParam(2, CMD_QUERY);
        if (this.handleErrors()) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        FishQuery q = FishQuery.parse(query, errors);
        if (q == null) {
            this.api.addErrors(errors);
            this.handleErrors();
            return;
        }
        try {
            SearchManager search = rep.getSearchManager();
            SearchResults collator = search.runQuery(q, true);
            this.api.startResponse();
            if (collator.hasTabularResults()) {
                this.sendTabularResults(collator);
            } else {
                this.sendRevisionResults(collator);
            }
            this.api.endResponse();
        }
        catch (Exception e2) {
            this.api.sendError(e2.getMessage());
        }
    }

    private void sendTabularResults(SearchResults results) throws Exception {
        ReturnClause md = results.getMetaData();
        this.api.openArray();
        SearchResults.TabularResultsIterator i2 = results.iterateData(0);
        while (i2.hasNext()) {
            this.api.openArrayValue();
            SearchResults.ResultRow row = i2.nextRow();
            this.api.openStruct0("row");
            this.api.openStruct1();
            for (int c2 = 0; c2 < md.numFields(); ++c2) {
                this.sendField(md, row, c2);
            }
            this.api.closeStruct("row");
            this.api.closeArrayValue();
        }
        this.api.closeArray();
    }

    private void sendField(ReturnClause md, SearchResults.ResultRow row, int c2) throws IOException {
        ReturnClause.Field f2 = md.getField(c2);
        String columnName = f2.getColumnName();
        switch (f2.getType()) {
            case DATE: {
                this.api.writeDateMember(columnName, row.getDate(c2));
                break;
            }
            case INTEGER: {
                this.api.writeIntMember(columnName, row.getInt(c2));
                break;
            }
            case STRING_ARRAY: {
                this.api.writeTextArrayMember(columnName, row.getStringArray(c2));
                break;
            }
            case MAP_ARRAY: {
                String entryName = "reviews".equals(columnName) ? "review" : "entry";
                this.api.writeTextMapMember(columnName, entryName, row.getMapArray(c2));
                break;
            }
            default: {
                this.api.writeTextMember(columnName, row.getString(c2));
            }
        }
    }

    private void sendRevisionResults(SearchResults results) throws Exception {
        this.api.openArray();
        SearchResults.RevisionResultsIterator i2 = results.iterateRevisions(0);
        while (i2.hasNext()) {
            this.api.openArrayValue();
            this.sendRevisionKey(i2.nextItem().getRevInfoKey());
            this.api.closeArrayValue();
        }
        this.api.closeArray();
    }

    private void sendRevisionKey(RevInfoKey rev) throws IOException {
        this.api.openStruct0("revisionkey");
        this.api.writeTextAttribute("path", rev.getPath().getPath());
        this.api.writeTextAttribute("rev", rev.getRev());
        this.api.openStruct1();
        this.api.closeStruct("revisionkey");
    }

    private void doLogout() throws IOException {
        this.getAuthTokenParam();
        if (this.handleErrors()) {
            return;
        }
        try {
            this.api.getContext().logout(this.mUser);
            boolean result = true;
            this.api.startResponse();
            this.api.writeBooleanValue(result);
            this.api.endResponse();
        }
        catch (DbException e2) {
            this.api.sendError("Internal error with logout");
            Logs.APP_LOG.warn((Object)"problem logout", (Throwable)e2);
        }
    }

    private void doFishEyeVersion() throws IOException {
        this.api.startResponse();
        this.api.writeTextValue("1.5.4");
        this.api.endResponse();
    }

    private void doCrucibleVersion() throws IOException {
        this.api.startResponse();
        if (AppConfig.isCrucible()) {
            this.api.writeTextValue("1.5.4");
        } else {
            this.api.writeTextValue("");
        }
        this.api.endResponse();
    }

    private void doLogin() throws IOException {
        String username = this.getRequiredStringParam(0, "username");
        String password = this.getRequiredStringParam(1, "password");
        if (this.handleErrors()) {
            return;
        }
        try {
            LoginCookie c2 = this.api.getContext().login(username, password);
            if (c2 == null) {
                this.api.sendError("authentication failed");
                return;
            }
            this.api.startResponse();
            this.api.writeTextValue(c2.encode());
            this.api.endResponse();
        }
        catch (DbException e2) {
            this.api.sendError("Internal error with login");
            Logs.APP_LOG.warn((Object)"problem logging in user", (Throwable)e2);
        }
        catch (LicensePolicyException e3) {
            this.api.sendError("Problem with login: " + e3.getMessage());
            Logs.APP_LOG.warn((Object)"problem logging in user", (Throwable)e3);
        }
    }

    private void doListPaths() throws IOException {
        Path child;
        int i2;
        Path[] files;
        Path[] dirs;
        this.getAuthTokenParam();
        this.getRepositoryParam(1, "rep");
        String path = this.getRequiredStringParam(2, "path");
        if (this.handleErrors()) {
            return;
        }
        Path dir = new Path(path);
        try {
            if (!this.mDB.isDir(dir)) {
                this.api.sendError("not a directory: " + path);
                return;
            }
        }
        catch (DbException e2) {
            ApiImplementation.logApiException(e2);
            this.api.sendError(e2.getMessage());
            return;
        }
        try {
            dirs = this.mDB.listDirs(dir);
        }
        catch (DbException e3) {
            ApiImplementation.logApiException(e3);
            this.api.sendError(e3.getMessage());
            return;
        }
        try {
            files = this.mDB.listFiles(dir);
        }
        catch (DbException e4) {
            ApiImplementation.logApiException(e4);
            this.api.sendError(e4.getMessage());
            return;
        }
        this.api.startResponse();
        this.api.openArray();
        for (i2 = 0; i2 < dirs.length; ++i2) {
            child = dirs[i2];
            this.api.openArrayValue();
            this.sendPathInfo(child.getName(), false, true, false);
            this.api.closeArrayValue();
        }
        for (i2 = 0; i2 < files.length; ++i2) {
            child = files[i2];
            this.api.openArrayValue();
            try {
                FileHistory history = this.mDB.getFileHistory(child);
                this.sendPathInfo(child.getName(), true, false, this.isHeadDeleted(history));
            }
            catch (DbException e5) {
                ApiImplementation.logApiException(e5);
                this.api.sendError(e5.getMessage());
                return;
            }
            this.api.closeArrayValue();
        }
        this.api.closeArray();
        this.api.endResponse();
    }

    private boolean isHeadDeleted(FileHistory history) throws DbException {
        String head = history.getHead();
        if (head == null) {
            return false;
        }
        FileRevision rev = history.getRevision(head);
        return rev == null ? false : rev.isDead();
    }

    private void sendPathInfo(String name, boolean isFile, boolean isDir, boolean isHeadDeleted) throws IOException {
        this.api.openStruct0("pathinfo");
        this.api.writeTextAttribute("name", name);
        this.api.writeBooleanAttribute("isFile", isFile);
        this.api.writeBooleanAttribute("isDir", isDir);
        this.api.writeBooleanAttribute("isHeadDeleted", isHeadDeleted);
        this.api.openStruct1();
        this.api.closeStruct("pathinfo");
    }

    private void doListRepositories() throws IOException {
        this.getAuthTokenParam();
        if (this.handleErrors()) {
            return;
        }
        List<RepositoryHandle> reps = AppConfig.getsConfig().getRepositoryManager().getHandles();
        this.api.startResponse();
        this.api.openArray();
        for (RepositoryHandle rep : reps) {
            this.api.openArrayValue();
            this.api.writeTextValue(rep.getName());
            this.api.closeArrayValue();
        }
        this.api.closeArray();
        this.api.endResponse();
    }

    private void doGetChangeset() throws IOException {
        ChangeSet cs;
        this.getAuthTokenParam();
        RepositoryEngine rcfg = this.getRepositoryParam(1, "rep");
        String csid = this.getRequiredStringParam(2, "csid");
        if (this.handleErrors()) {
            return;
        }
        RevisionCache crep = rcfg.getRevisionCache();
        try {
            cs = crep.getChangeSet(csid);
            if (cs == null) {
                this.api.sendError("not a valid changeset id: " + csid);
                return;
            }
        }
        catch (DbException e2) {
            ApiImplementation.logApiException(e2);
            this.api.sendError(e2.getMessage());
            return;
        }
        this.sendChangeset(cs);
    }

    private void doListChangesets() throws IOException {
        List csids;
        this.getAuthTokenParam();
        this.getRepositoryParam(1, "rep");
        String path = this.getRequiredStringParam(2, "path");
        Long startDate = this.api.getDateParam(3, "start");
        Long endDate = null;
        if (startDate != null) {
            endDate = this.api.getDateParam(4, "end");
        }
        if (this.handleErrors()) {
            return;
        }
        int maxReturn = 3000;
        RecentChangesParams params = new RecentChangesParams();
        try {
            Path dir = new Path(path);
            if (!this.mDB.isDir(dir)) {
                this.api.sendError("not a directory: " + path);
                return;
            }
            params.setPath(dir);
        }
        catch (DbException e2) {
            ApiImplementation.logApiException(e2);
            this.api.sendError(e2.getMessage());
            return;
        }
        params.setMaxReturn(3000);
        if (startDate != null) {
            params.setMinDate(startDate);
        }
        if (endDate != null) {
            params.setMaxDate(endDate);
        }
        try {
            csids = this.mDB.findRecentChangeSetIds(params);
        }
        catch (DbException e3) {
            ApiImplementation.logApiException(e3);
            this.api.sendError(e3.getMessage());
            return;
        }
        this.sendChanges(csids, 3000);
    }

    private void doGetRevision() throws IOException {
        FileRevision rInfo = this.parseRevisionRequest();
        if (rInfo == null) {
            return;
        }
        this.sendInfo(rInfo);
    }

    private void doListTagsRevision() throws IOException {
        FileRevision rInfo = this.parseRevisionRequest();
        if (rInfo == null) {
            return;
        }
        this.sendListTagsForRevision(rInfo);
    }

    private FileRevision parseRevisionRequest() throws IOException {
        this.getAuthTokenParam();
        this.getRepositoryParam(1, "rep");
        String path = this.getRequiredStringParam(2, "path");
        String rev = this.getRequiredStringParam(3, "rev");
        if (this.handleErrors()) {
            return null;
        }
        try {
            RevInfoKey rik = new RevInfoKey(new Path(path), rev);
            FileRevision rinfo = this.mDB.getFileRevision(rik);
            if (rinfo == null) {
                this.api.sendError("file/revision not found: " + rik);
                return null;
            }
            return rinfo;
        }
        catch (DbException e2) {
            ApiImplementation.logApiException(e2);
            this.api.sendError(e2.getMessage());
            return null;
        }
    }

    private void sendListTagsForRevision(FileRevision rinfo) throws IOException {
        this.api.startResponse();
        this.api.openArray();
        for (String tag : rinfo.getTags()) {
            this.api.openArrayValue();
            this.api.writeTextValue(tag);
            this.api.closeArrayValue();
        }
        this.api.closeArray();
        this.api.endResponse();
    }

    private void doListPathHistory() throws IOException {
        FileHistory info;
        this.getAuthTokenParam();
        this.getRepositoryParam(1, "rep");
        String path = this.getRequiredStringParam(2, "path");
        if (this.handleErrors()) {
            return;
        }
        try {
            info = this.mDB.getFileHistory(new Path(path));
        }
        catch (DbException e2) {
            ApiImplementation.logApiException(e2);
            this.api.sendError(e2.getMessage());
            return;
        }
        if (info != null) {
            this.sendInfo(info);
        } else {
            this.api.sendError("path not found: " + path);
        }
    }

    private void sendChangeset(ChangeSet cs) throws IOException {
        this.api.startResponse();
        String branch = null;
        Iterator<RevInfoKey> revKeysIterator = null;
        try {
            branch = cs.getBranch();
            revKeysIterator = cs.getRevisionInfoKeys();
        }
        catch (DbException e2) {
            ApiImplementation.logApiException(e2);
            this.api.sendError(e2.getMessage());
            return;
        }
        this.api.openStruct0("changeset");
        this.api.writeTextAttribute("csid", cs.getId());
        this.api.writeDateAttribute("date", cs.getDate());
        this.api.writeTextAttribute("author", cs.getAuthor());
        this.api.writeTextAttribute("branch", branch);
        this.api.openStruct1();
        this.api.writeTextMember("log", cs.getComment());
        this.api.openArrayMember("revisions");
        Iterator<RevInfoKey> i2 = revKeysIterator;
        while (i2.hasNext()) {
            this.api.openArrayValue();
            this.sendRevisionKey(i2.next());
            this.api.closeArrayValue();
        }
        this.api.closeArrayMember("revisions");
        this.api.closeStruct("changeset");
        this.api.endResponse();
    }

    private void sendInfo(FileRevision info) throws IOException {
        this.api.startResponse();
        this.writeRevisionInfo(info);
        this.api.endResponse();
    }

    private void sendInfo(FileHistory info) throws IOException {
        this.api.startResponse();
        this.api.openStruct0("history");
        this.api.openStruct1();
        this.api.openArrayMember("revisions");
        Collection origRevs = info.getRevisions();
        ArrayList revisions = new ArrayList(origRevs);
        Collections.sort(revisions, FileRevision.OldestFirstComparator.INSTANCE);
        Collections.reverse(revisions);
        Iterator i2 = revisions.iterator();
        while (i2.hasNext()) {
            this.api.openArrayValue();
            FileRevision rinfo = (FileRevision)i2.next();
            this.writeRevisionInfo(rinfo);
            this.api.closeArrayValue();
        }
        this.api.closeArrayMember("revisions");
        this.api.closeStruct("history");
        this.api.endResponse();
    }

    private void writeRevisionInfo(FileRevision rinfo) throws IOException {
        this.api.openStruct0("revision");
        this.api.writeTextAttribute("path", rinfo.getPath().getPath());
        this.api.writeTextAttribute("rev", rinfo.getRevision());
        this.api.writeTextAttribute("author", rinfo.getAuthor());
        this.api.writeDateAttribute("date", rinfo.getDate());
        String state = rinfo.isDead() ? "deleted" : (rinfo.isAdded() ? "added" : "changed");
        this.api.writeTextAttribute("state", state);
        this.api.writeIntAttribute("totalLines", rinfo.getLineCount());
        this.api.writeIntAttribute("linesAdded", rinfo.getLinesAdded());
        this.api.writeIntAttribute("linesRemoved", rinfo.getLinesRemoved());
        String csid = this.getChangesetId(rinfo);
        if (csid != null) {
            this.api.writeTextAttribute("csid", csid);
        }
        if (rinfo.getAncestorRevision() != null) {
            String arev = rinfo.getAncestorRevision();
            this.api.writeTextAttribute("ancestor", arev);
        }
        this.api.openStruct1();
        this.api.writeTextMember("log", rinfo.getComment());
        this.api.closeStruct("revision");
    }

    private void sendChanges(List changesets, int maxReturn) throws IOException {
        this.api.startResponse();
        this.api.openStruct0("changesets");
        this.api.writeIntAttribute("maxReturn", maxReturn);
        this.api.openStruct1();
        this.api.openArrayMember("csids");
        Iterator i2 = changesets.iterator();
        while (i2.hasNext()) {
            this.api.openArrayValue();
            this.api.writeTextValue((String)i2.next());
            this.api.closeArrayValue();
        }
        this.api.closeArrayMember("csids");
        this.api.closeStruct("changesets");
        this.api.endResponse();
    }

    public static void logApiException(Throwable e2) {
        Logs.APP_LOG.debug((Object)"api execution error", e2);
    }

    private String getChangesetId(FileRevision rinfo) {
        return rinfo.getChangeSetId();
    }

    private boolean accessAllowed(RepositoryHandle h2) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        return um.hasPermissionToAccess(this.mUser, h2);
    }
}

