/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.bucket.Period;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;

public abstract class CalculatedBucketGraph {
    private SimpleDateFormat tooltipDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private List<String> rcTooltips = new ArrayList<String>();
    private ChartRenderingInfo chartRenderingInfo;
    private static final Map<String, String> labelMap = new HashMap<String, String>();

    public void addRevcountTooltip(Period period, int value, String branch) {
        this.rcTooltips.add(value + " - " + period.getStringTT(this.tooltipDateFormat) + " " + branch);
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.chartRenderingInfo;
    }

    public void setChartRenderingInfo(ChartRenderingInfo chartRenderingInfo) {
        this.chartRenderingInfo = chartRenderingInfo;
    }

    public List getRevcountTooltips() {
        return this.rcTooltips;
    }

    public abstract String[] getLegendItems();

    public abstract boolean noGraphData();

    protected String formatLabel(String label) {
        return labelMap.containsKey(label) ? labelMap.get(label) : label;
    }

    static {
        labelMap.put("__NO_EXTENSION__", "None");
        labelMap.put("__NO_AUTHOR__", "No author");
    }
}

