/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.bucket;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.Dir;
import com.cenqua.fisheye.rep.DbException;

public class ParameterSet {
    protected final Path path;
    public final String branch;
    public static final String NO_EXTENSION = "__NO_EXTENSION__";
    public static final String NO_AUTHOR = "__NO_AUTHOR__";
    public static final String ALL_AUTHORS = "__ALL_AUTHORS__";
    public static final String ALL_EXTENSIONS = "__ALL_EXTENSIONS__";
    public static final String TRUNKLIKE = "__TRUNKLIKE__";

    public ParameterSet(Path path) {
        this.path = path;
        this.branch = null;
    }

    public Dir loadSubdir(Dir dir, int depth) throws DbException {
        return dir.loadSubdir(this.getPath(depth + 1));
    }

    public boolean isTrunkLike() {
        return this.branch.equals(TRUNKLIKE);
    }

    protected Position getPosition(int depth) {
        if (depth < this.path.numComponents() - 1) {
            return Position.BeforeLast;
        }
        if (depth == this.path.numComponents() - 1) {
            return Position.AtLast;
        }
        return Position.AfterLast;
    }

    private String replaceIfNull(String newValue, String defaultValue) {
        return newValue == null ? defaultValue : newValue;
    }

    public ParameterSet(Path path, String branch, boolean caseSensitive) {
        Path path2 = this.path = path == null ? new Path() : path;
        if (!caseSensitive) {
            this.path.toLowerCase();
        }
        this.branch = this.replaceIfNull(branch, TRUNKLIKE);
    }

    public String toString() {
        return "Parameters: path " + this.path + ", branch " + this.branch;
    }

    protected String getPath(int index) {
        return this.path.getComponent(index);
    }

    public String getPathToDepth(int depth) {
        String result = "";
        for (int i2 = 0; i2 <= depth; ++i2) {
            result = result + "/" + this.getPath(i2);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Position {
        BeforeLast,
        AtLast,
        AfterLast;

    }
}

