/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeClassLoader;
import com.cenqua.fisheye.FishEyeCtl;
import com.cenqua.fisheye.boot.Os;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.util.regex.Pattern;

public class NativeLibrarySetup {
    private static final Alternative[] OS_ALTERNATIVES = new Alternative[]{new Alternative("mac os.*", new String[]{"osx"}), new Alternative("windows.*", new String[]{"win32"}), new Alternative("sunos.*", new String[]{"solaris"})};
    private static final Alternative[] ARCH_ALTERNATIVES = new Alternative[]{new Alternative("(x|i.?)86", new String[]{"x86", "i386", "i486", "i586", "i686"})};

    public static void setup() {
        FishEyeClassLoader cl = FishEyeCtl.CLASSLOADER;
        if (cl == null) {
            return;
        }
        String os = Os.osName;
        String arch = Os.osArch;
        File nativeDir = NativeLibrarySetup.findNativeDir(new File(AppConfig.getAppHome(), "lib/native"), os, arch);
        if (nativeDir != null) {
            Logs.APP_LOG.debug((Object)("for " + os + "/" + arch + ", using native dir " + nativeDir));
            cl.addLibraryDir(nativeDir);
        } else {
            Logs.APP_LOG.debug((Object)("could not find native dir for " + os + "/" + arch));
        }
        String flp = System.getProperty("fisheye.library.path");
        if (flp != null) {
            cl.addLibraryPath(flp);
        }
    }

    static File findNativeDir(File dir, String os, String arch) {
        File nativeDir = NativeLibrarySetup.tryDir(dir, os, arch);
        if (nativeDir != null) {
            return nativeDir;
        }
        nativeDir = NativeLibrarySetup.tryArchAlternatives(dir, os, arch);
        if (nativeDir != null) {
            return nativeDir;
        }
        return NativeLibrarySetup.tryOsAlternatives(dir, os, arch);
    }

    private static File tryOsAlternatives(File dir, String os, String arch) {
        for (int i2 = 0; i2 < OS_ALTERNATIVES.length; ++i2) {
            Alternative osAlt = OS_ALTERNATIVES[i2];
            if (!osAlt.pattern.matcher(os).matches()) continue;
            String[] osAlts = osAlt.alternatives;
            for (int j = 0; j < osAlts.length; ++j) {
                String osa = osAlts[j];
                File nativeDir = NativeLibrarySetup.tryDir(dir, osa, arch);
                if (nativeDir != null) {
                    return nativeDir;
                }
                nativeDir = NativeLibrarySetup.tryArchAlternatives(dir, osa, arch);
                if (nativeDir == null) continue;
                return nativeDir;
            }
        }
        return null;
    }

    private static File tryArchAlternatives(File dir, String os, String arch) {
        for (int i2 = 0; i2 < ARCH_ALTERNATIVES.length; ++i2) {
            Alternative archAlt = ARCH_ALTERNATIVES[i2];
            if (!archAlt.pattern.matcher(arch).matches()) continue;
            String[] archAlts = archAlt.alternatives;
            for (int j = 0; j < archAlts.length; ++j) {
                String archa = archAlts[j];
                File nativeDir = NativeLibrarySetup.tryDir(dir, os, archa);
                if (nativeDir == null) continue;
                return nativeDir;
            }
        }
        return null;
    }

    private static File tryDir(File dir, String os, String arch) {
        File nativeDir = new File(dir, os + "-" + arch);
        return nativeDir.isDirectory() ? nativeDir : null;
    }

    private static class Alternative {
        final Pattern pattern;
        final String[] alternatives;

        public Alternative(String pattern, String[] alternatives) {
            this.pattern = Pattern.compile(pattern);
            this.alternatives = alternatives;
        }
    }
}

