/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.CvsUpdaterType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.cvsrep.CvsRepositoryEngine;
import com.cenqua.fisheye.cvsrep.CvsRepositoryTester;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryTester;
import com.cenqua.fisheye.util.Interval;
import java.io.File;
import java.nio.charset.Charset;

public class CvsRepositoryConfig
extends RepositoryConfig {
    public static Charset DEFAULT_CVS_ENCODING = Charset.forName("ISO-8859-1");
    private File mHistoryFile;
    private long mFullScanPeriod = 900000L;
    private String mHistoryStripPrefix;
    private Charset mCharset = DEFAULT_CVS_ENCODING;
    private final File mCvsRoot;

    public CvsRepositoryConfig(RepositoryType config, RepositoryDefaultsType configDefaults) throws ConfigException {
        super(config, configDefaults);
        this.getStatus().setEngineError("");
        CvsRepType cvsE = config.getCvs();
        if (cvsE == null) {
            throw new ConfigException(this.getName() + " did not contain expected <cvs>");
        }
        this.mCvsRoot = new File(cvsE.getDir());
        this.mHistoryFile = new File(this.mCvsRoot, "CVSROOT/history");
        if (!this.mCvsRoot.isDirectory()) {
            Logs.APP_LOG.error((Object)("path for repository " + this.getName() + " is not a directory:" + this.mCvsRoot));
            this.getStatus().setEngineError("WARN: unable to find repository root: " + this.mCvsRoot);
        }
        this.setup(cvsE);
    }

    public RepositoryEngine createRepositoryEngine() {
        return new CvsRepositoryEngine(this);
    }

    public RepositoryTester createRepositoryTester() {
        return new CvsRepositoryTester(this);
    }

    private void setup(CvsRepType cvsE) throws ConfigException {
        if (cvsE.isSetCharset()) {
            String cs = cvsE.getCharset();
            try {
                this.mCharset = Charset.forName(cs);
            }
            catch (IllegalArgumentException e2) {
                throw new ConfigException("Not a valid encoding name: '" + cs + "'. Valid names are " + Charset.availableCharsets().keySet(), e2);
            }
        }
        if (cvsE.isSetUpdater()) {
            this.parseCvsUpdater(cvsE.getUpdater());
        }
    }

    public File getCvsRoot() {
        return this.mCvsRoot;
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    private void parseCvsUpdater(CvsUpdaterType e2) {
        String prefix;
        String fsStr;
        CvsUpdaterType.Historyfile historyFile = e2.getHistoryfile();
        String fname = historyFile.getFile();
        if (fname != null) {
            this.mHistoryFile = CvsRepositoryConfig.maybeRelativeFile(this.getCvsRoot(), fname);
        }
        if ((fsStr = historyFile.getFullScanPeriod()) != null) {
            try {
                Interval period = new Interval(fsStr);
                this.mFullScanPeriod = period.getValueInMillis();
            }
            catch (NumberFormatException ex) {
                Logs.APP_LOG.warn((Object)("could not parse fullScanPeriod: " + ex.getMessage()));
            }
        }
        if ((prefix = historyFile.getStripPrefix()) != null) {
            this.mHistoryStripPrefix = prefix;
        }
    }

    public File getHistoryFile() {
        return this.mHistoryFile;
    }

    public long getFullScanPeriod() {
        return this.mFullScanPeriod;
    }

    public String getHistoryStripPrefix() {
        return this.mHistoryStripPrefix;
    }

    private static File maybeRelativeFile(File relativeTo, String fname) {
        File f2 = new File(fname);
        if (!f2.isAbsolute()) {
            f2 = new File(relativeTo, fname);
        }
        return f2;
    }
}

