/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.StreamLineReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiffParser {
    private static final Pattern ADD_DEL_LINE = Pattern.compile("([ad])(\\d+)\\s+(\\d+)\\s*");
    private final LineReader mStream;

    public DiffParser(LineReader stream) {
        this.mStream = stream;
    }

    public DiffParser(InputStream aStream) {
        this.mStream = new StreamLineReader(LineReader.Mode.MODE_UNIX, aStream);
    }

    public void parseHunks(DiffListener aListener) throws IOException {
        String line;
        Matcher matcher = ADD_DEL_LINE.matcher("");
        int skipcount = 0;
        boolean adding = false;
        while ((line = this.mStream.readLine()) != null) {
            if (skipcount > 0) {
                --skipcount;
                if (!adding) continue;
                aListener.addLine(line);
                continue;
            }
            adding = false;
            matcher.reset(line);
            if (!matcher.matches()) continue;
            String mode = matcher.group(1);
            int l = Integer.parseInt(matcher.group(2));
            int n = Integer.parseInt(matcher.group(3));
            boolean isAdd = mode.equals("a");
            if (isAdd) {
                skipcount = n;
                aListener.startAdd(l, n);
                adding = true;
                continue;
            }
            aListener.delete(l, n);
        }
    }

    public static interface DiffListener {
        public void delete(int var1, int var2);

        public void startAdd(int var1, int var2);

        public void addLine(String var1);
    }
}

