/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.KeywordExpansion;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcsRevisionInfo
implements CommonFileRevisionInput {
    private final List<String> mSymbols = new ArrayList<String>();
    private int mLineCount;
    private int mLinesAdded;
    private int mLinesRemoved;
    private final Revision mRevision;
    private long mDate;
    private String mAuthor;
    private String mComment;
    private String mState;
    private RcsRevisionInfo mAncestor;
    private int ancestorType;
    private RcsRevisionInfo mNextInBranch;
    private final RcsFileHistory mFile;
    private int revid = -1;
    private boolean newlyAdded;
    private String mThisBranch;
    private List<Hunk> hunks;

    public RcsRevisionInfo(RcsFileHistory file, Revision aRevision) {
        this.mRevision = aRevision;
        this.mFile = file;
    }

    @Override
    public String getChangeSetId() {
        return null;
    }

    public int getRevID() {
        return this.revid;
    }

    public void setRevID(int revid) {
        this.revid = revid;
    }

    @Override
    public int getFileType() {
        return 1;
    }

    public boolean isNewlyAdded() {
        return this.newlyAdded;
    }

    public void setNewlyAdded(boolean newlyAdded) {
        this.newlyAdded = newlyAdded;
    }

    @Override
    public String getRevision() {
        return this.mRevision.toString();
    }

    public Revision getCvsRevision() {
        return this.mRevision;
    }

    public RcsFileHistory getFile() {
        return this.mFile;
    }

    @Override
    public Path getPath() {
        return this.getFile().getPath();
    }

    public String getState() {
        return this.mState;
    }

    public void setState(String aState) {
        this.mState = aState;
    }

    @Override
    public boolean isDead() {
        return "dead".equals(this.getState());
    }

    @Override
    public boolean isAdded() {
        RcsRevisionInfo prev = this.getAncestor();
        if (prev != null) {
            return prev.isDead();
        }
        return true;
    }

    @Override
    public boolean isBinary() {
        return this.getFile().isBinary();
    }

    @Override
    public String getComment() {
        return this.mComment;
    }

    public void setComment(String aComment) {
        this.mComment = aComment;
    }

    public RcsRevisionInfo getAncestor() {
        return this.mAncestor;
    }

    public void setAncestor(RcsRevisionInfo aAncestor, int ancestorType) {
        this.mAncestor = aAncestor;
        this.ancestorType = ancestorType;
    }

    public int getAncestorType() {
        return this.ancestorType;
    }

    public String getAncestorRevision() {
        return this.mAncestor == null ? null : this.mAncestor.getRevision();
    }

    public RcsRevisionInfo getNextInBranch() {
        return this.mNextInBranch;
    }

    public void setNextInBranch(RcsRevisionInfo nextInBranch) {
        this.mNextInBranch = nextInBranch;
    }

    @Override
    public long getDate() {
        return this.mDate;
    }

    @Override
    public String getAuthor() {
        return this.mAuthor;
    }

    public void setDate(long aDate) {
        this.mDate = aDate;
    }

    public void setAuthor(String aAuthor) {
        this.mAuthor = aAuthor;
    }

    public List<String> getTags() {
        return this.mSymbols;
    }

    @Override
    public String getBranch() {
        return this.mThisBranch;
    }

    @Override
    public boolean isTrunkLike() {
        return "MAIN".equals(this.mThisBranch);
    }

    public RevInfoKey getRevInfoKey() {
        return new RevInfoKey(this.getPath(), this.getRevision());
    }

    void setThisBranch(String thisBranch) {
        this.mThisBranch = thisBranch;
    }

    public List<String> getBranches() {
        return this.mFile.getBranches(this.mRevision);
    }

    void addSymbol(String aSym) {
        this.mSymbols.add(aSym);
    }

    @Override
    public int getLineCount() {
        return this.mLineCount;
    }

    public void setLineCount(int lineCount) {
        this.mLineCount = lineCount;
    }

    @Override
    public int getLinesAdded() {
        return this.mLinesAdded;
    }

    @Override
    public int getLinesRemoved() {
        return this.mLinesRemoved;
    }

    public void setLinesChanged(int linesAdded, int linesRemoved, List<Hunk> hunks) {
        this.mLinesRemoved = linesRemoved;
        this.mLinesAdded = linesAdded;
        this.hunks = hunks;
    }

    public String toString() {
        return "RcsRevisionInfo[" + this.getFile() + " " + this.getRevision() + "]";
    }

    public RevInfoKey getInfoKey() {
        return new RevInfoKey(this.getFile().getPath(), this.getRevision());
    }

    void fixup() {
        if (this.mAuthor == null) {
            Logs.APP_LOG.warn((Object)("no author for " + this.getFile().getPath() + " " + this.getRevision()));
            this.mAuthor = "UNKNOWN";
        }
        if (this.mComment == null) {
            this.mComment = "";
        }
    }

    @Override
    public boolean isCopy() {
        return false;
    }

    @Override
    public boolean isMove() {
        return false;
    }

    @Override
    public boolean isModify() {
        return true;
    }

    public KeywordExpansion.KeywordExpansionInfo makeKeywordExpansionInfo(String tagname) {
        if (this.getRevision().equals(tagname)) {
            tagname = null;
        }
        return new KeywordExpansion.KeywordExpansionInfo(this.getAuthor(), this.getDate(), this.getRevision(), this.getState(), tagname);
    }

    public KeywordExpansion.KeywordExpansionInfo makeKeywordExpansionInfo() {
        return this.makeKeywordExpansionInfo(null);
    }

    @Override
    public List<Hunk> getHunks() {
        return this.hunks;
    }
}

