/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep.search;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.search.query.AndClause;
import com.cenqua.fisheye.cvsrep.search.query.AuthorsClause;
import com.cenqua.fisheye.cvsrep.search.query.CommentClause;
import com.cenqua.fisheye.cvsrep.search.query.ContentClause;
import com.cenqua.fisheye.cvsrep.search.query.DateRangeClause;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.cvsrep.search.query.HeadClause;
import com.cenqua.fisheye.cvsrep.search.query.OnBranchClause;
import com.cenqua.fisheye.cvsrep.search.query.PathClause;
import com.cenqua.fisheye.cvsrep.search.query.QueryLangLexer;
import com.cenqua.fisheye.cvsrep.search.query.QueryLangParser;
import com.cenqua.fisheye.cvsrep.search.query.ReturnClause;
import com.cenqua.fisheye.cvsrep.search.query.TaggedClause;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.UrlHelper;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.lucene.analysis.Analyzer;

public class SimpleSearchParameters {
    private final HttpServletRequest req;
    private final Analyzer mAnalyzer;

    public SimpleSearchParameters(HttpServletRequest req, Analyzer analyzer) {
        this.req = req;
        this.mAnalyzer = analyzer;
    }

    public FishQuery parseUserData(Path underPath, UrlHelper searchUrl) {
        String[] cols;
        String filename;
        String comment;
        String contents;
        String branch;
        FishQuery qb = new FishQuery();
        qb.setFromPath(underPath);
        boolean sufficientCriteria = false;
        AndClause clauses = new AndClause();
        qb.setWhereClause(clauses);
        String[] authors = this.req.getParameterValues("author");
        if (authors != null && authors.length > 0) {
            ArrayList<String> l = new ArrayList<String>();
            for (String author : authors) {
                if (SimpleSearchParameters.isEmpty(author)) continue;
                l.add(author);
                searchUrl.putMulti("author", author);
            }
            clauses.addClause(new AuthorsClause(l));
            sufficientCriteria = true;
        }
        String head = this.req.getParameter("head");
        boolean isHead = false;
        if (!SimpleSearchParameters.isEmpty(head)) {
            isHead = "true".equals(head);
            searchUrl.getParams().put("head", "true");
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(branch = this.req.getParameter("branch"))) {
            if (isHead) {
                clauses.addClause(new HeadClause(branch));
            } else {
                clauses.addClause(new OnBranchClause(branch, false, false, false));
            }
            searchUrl.getParams().put("branch", branch);
            sufficientCriteria = true;
        } else if (isHead) {
            clauses.addClause(new HeadClause(null));
        }
        String tag = this.req.getParameter("tag");
        if (!SimpleSearchParameters.isEmpty(tag)) {
            clauses.addClause(new TaggedClause(tag, 1));
            searchUrl.getParams().put("tag", tag);
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(contents = this.req.getParameter("contents"))) {
            clauses.addClause(new ContentClause(contents));
            searchUrl.getParams().put("contents", contents);
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(comment = this.req.getParameter("comment"))) {
            clauses.addClause(new CommentClause(comment));
            searchUrl.getParams().put("comment", comment);
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(filename = this.req.getParameter("filename"))) {
            clauses.addClause(new PathClause(filename, false));
            searchUrl.getParams().put("filename", filename);
            sufficientCriteria = true;
        }
        String fromStr = this.req.getParameter("fromdate");
        String toStr = this.req.getParameter("todate");
        long now = System.currentTimeMillis();
        TimeZone tz = AppConfig.getsConfig().getTimezone();
        Long fromDate = DateHelper.parseDate(fromStr, now, tz);
        Long toDate = DateHelper.parseDate(toStr, now, tz);
        if (fromDate != null || toDate != null) {
            DateRangeClause dc = new DateRangeClause();
            if (fromDate != null) {
                dc.setMin(fromDate);
                dc.setMinInclusive(true);
                searchUrl.getParams().put("fromdate", fromStr);
            }
            if (toDate != null) {
                dc.setMax(toDate);
                dc.setMaxInclusive(true);
                searchUrl.getParams().put("todate", toStr);
            }
            clauses.addClause(dc);
            sufficientCriteria = true;
        }
        qb.setGroupBy(4);
        String gb = this.req.getParameter("groupby");
        if (gb != null) {
            searchUrl.getParams().put("groupby", gb);
            if ("file".equals(gb)) {
                qb.setGroupBy(2);
            } else if ("dir".equals(gb)) {
                qb.setGroupBy(3);
            } else if ("changeset".equals(gb)) {
                qb.setGroupBy(4);
            } else if ("revision".equals(gb)) {
                qb.setGroupBy(1);
            }
        }
        if ((cols = this.req.getParameterValues("col")) != null && cols.length > 0) {
            ReturnClause rc = new ReturnClause();
            for (String col : cols) {
                ReturnClause.Field f2 = this.parseReturnField(col);
                if (f2 == null) continue;
                rc.addField(f2);
                searchUrl.putMulti("col", col);
            }
            qb.setReturnClause(rc);
        }
        if (sufficientCriteria) {
            return qb;
        }
        return null;
    }

    private ReturnClause.Field parseReturnField(String col) {
        try {
            QueryLangLexer lex = new QueryLangLexer(new StringReader(col));
            QueryLangParser parser = new QueryLangParser(lex);
            return parser.returnField();
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)("Problem parsing field: " + col), (Throwable)e2);
            return null;
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

