/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Disposable;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import java.io.File;
import java.io.IOException;

public class InfDbCache
implements Disposable {
    private long mCacheSize = 0x500000L;
    private File mCacheDir;
    private InfinityDbHandle mDB;

    public void open() throws IOException {
        File dbfile = new File(this.mCacheDir, "data.bin");
        this.mDB = new InfinityDbHandle(dbfile, this.mCacheSize);
    }

    protected UniqueStringTable createStringTable(_EntityClass entityClass) {
        return new UniqueStringTable(this.mDB, entityClass);
    }

    public void setCacheSize(long cacheSize) {
        this.mCacheSize = cacheSize;
    }

    public void setCacheDir(File cacheDir) {
        this.mCacheDir = cacheDir;
    }

    protected InfinityDbHandle getDatabase() {
        return this.mDB;
    }

    public void touch() throws DbException {
    }

    public void commit() throws DbException {
        try {
            this.mDB.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void reallyClose() {
        try {
            this.mDB.close();
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"problem closign database", (Throwable)e2);
        }
    }

    public void dispose() throws Exception {
        this.commit();
    }

    protected void insert(_Cu cursor) throws DbException {
        try {
            _k4ui8vIDB db = this.mDB.get();
            ((_ItemSpace)db).insert(cursor);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected void update(_Cu cursor, int pl) throws DbException {
        try {
            _k4ui8vIDB db = this.mDB.get();
            ((_ItemSpace)db).update(cursor, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    protected boolean next(_Cu cursor, int pl) throws DbException {
        try {
            _k4ui8vIDB db = this.mDB.get();
            return ((_ItemSpace)db).next(cursor, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLongValue(_EntityClass entityClass, String key, long value) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(entityClass).append(key);
            int p1 = cu.length();
            cu.append(value);
            this.update(cu, p1);
        }
        finally {
            _Cu.dispose(cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongValue(_EntityClass entityClass, String key, long defaultValue) throws DbException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(entityClass).append(key);
            int p1 = cu.length();
            if (this.next(cu, p1)) {
                long v;
                long l = v = cu.longAt(p1);
                return l;
            }
            long l = defaultValue;
            return l;
        }
        finally {
            _Cu.dispose(cu);
        }
    }
}

