/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.infinitydb;

import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import java.io.File;
import java.io.IOException;

public class InfinityDbUtil {
    public static boolean createIfNeccessary(File dbFile) throws IOException {
        if (dbFile.isFile()) {
            return false;
        }
        File parentDir = dbFile.getParentFile();
        if (parentDir != null) {
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new IOException("could not create parent directory " + parentDir + " for db file " + dbFile.getName());
            }
            if (!parentDir.isDirectory()) {
                throw new IOException("could not create parent for " + dbFile);
            }
        }
        _k4ui8vIDB db = _k4ui8vIDB.create(dbFile.getAbsolutePath(), false);
        db.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long incrementLong(_ItemSpace db, _EntityClass constantsTable, String constantName) throws IOException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(constantsTable).append(constantName);
            int p1 = cu.length();
            long v = db.next(cu, p1) ? cu.longAt(p1) : 0L;
            cu.setLength(p1);
            cu.append(v + 1L);
            db.update(cu, p1);
            long l = v;
            return l;
        }
        finally {
            _Cu.dispose(cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLong(_ItemSpace db, _EntityClass constantsTable, String constantName) throws IOException {
        _Cu cu = _Cu.alloc();
        try {
            cu.append(constantsTable).append(constantName);
            int p1 = cu.length();
            long v = db.next(cu, p1) ? cu.longAt(p1) : 0L;
            long l = v;
            return l;
        }
        finally {
            _Cu.dispose(cu);
        }
    }
}

