/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.io;

import com.cenqua.fisheye.io.RandomAccessIOStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class BufferedRandomAccessInputStream
extends InputStream
implements RandomAccessIOStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final RandomAccessFile mFile;
    private final File mRealFile;
    private final byte[] buf;
    private int count = 0;
    private int pos = 0;
    private long fpos = 0L;
    protected long markpos = -1L;

    public BufferedRandomAccessInputStream(File realFile, RandomAccessFile aFile, int aSize) {
        if (aSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.mRealFile = realFile;
        this.mFile = aFile;
        this.buf = new byte[aSize];
    }

    public BufferedRandomAccessInputStream(File realFile, RandomAccessFile aFile) {
        this(realFile, aFile, 8192);
    }

    public BufferedRandomAccessInputStream(File aFile, int aSize) throws FileNotFoundException {
        this(aFile, new RandomAccessFile(aFile, "r"), aSize);
    }

    public BufferedRandomAccessInputStream(File aFile) throws FileNotFoundException {
        this(aFile, new RandomAccessFile(aFile, "r"));
    }

    public File getFile() {
        return this.mRealFile;
    }

    public void seek(long newFpos) throws IOException {
        long fposDiff = newFpos - this.fpos;
        if (fposDiff >= 0L && fposDiff < (long)this.count) {
            this.pos = (int)fposDiff;
        } else {
            this.pos = 0;
            this.count = 0;
            this.fpos = newFpos;
            this.mFile.seek(this.fpos);
        }
    }

    public void mark() {
        this.markpos = this.getFilePointer();
    }

    public void mark(int readlimit) {
        this.mark();
    }

    public void reset() throws IOException {
        if (this.markpos < 0L) {
            throw new IOException("Resetting to invalid mark");
        }
        this.seek(this.markpos);
    }

    public void flush() throws IOException {
        this.pos = 0;
        this.count = 0;
        this.mFile.seek(this.fpos);
    }

    public long skip(long nbytes) throws IOException {
        if (nbytes < 0L) {
            return 0L;
        }
        if (nbytes < (long)(this.count - this.pos)) {
            this.pos = (int)((long)this.pos + nbytes);
            return nbytes;
        }
        this.fpos += (long)this.pos;
        this.pos = 0;
        this.count = 0;
        long dest = Math.min(this.fpos + nbytes, this.length());
        long skipped = dest - this.fpos;
        if (skipped > 0L) {
            this.fpos = dest;
            this.mFile.seek(this.fpos);
            return skipped;
        }
        return 0L;
    }

    public boolean markSupported() {
        return true;
    }

    public int available() throws IOException {
        return this.count - this.pos;
    }

    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] b2, int off, int len) throws IOException {
        int ncopied;
        int n;
        if ((off | len | off + len | b2.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        for (ncopied = 0; ncopied < len; ncopied += n) {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) break;
            }
            n = Math.min(len - ncopied, this.count - this.pos);
            System.arraycopy(this.buf, this.pos, b2, off + ncopied, n);
            this.pos += n;
        }
        return ncopied == 0 ? -1 : ncopied;
    }

    public long length() throws IOException {
        return this.mFile.length();
    }

    public long getFilePointer() {
        return this.fpos + (long)this.pos;
    }

    public void close() throws IOException {
        this.mFile.close();
    }

    private void fill() throws IOException {
        if (this.pos >= this.buf.length) {
            this.fpos += (long)this.pos;
            this.pos = 0;
        }
        this.count = this.pos;
        long actualfPos = this.mFile.getFilePointer();
        int n = this.mFile.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    public String readLine() throws IOException {
        StringBuffer input = new StringBuffer();
        int c2 = -1;
        boolean eol = false;
        block4: while (!eol) {
            c2 = this.read();
            switch (c2) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c2);
        }
        if (c2 == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public void streamContent(long position, int contentLength, int bufferSize, OutputStream out) throws IOException {
        int numRead;
        byte[] buffer = new byte[bufferSize];
        this.seek(position);
        for (int remaining = contentLength; remaining > 0; remaining -= numRead) {
            int readSize = Math.min(remaining, bufferSize);
            numRead = this.read(buffer, 0, readSize);
            out.write(buffer, 0, numRead);
        }
        out.flush();
    }
}

