/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.lucene;

import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PhraseQuery;

public class SmartPhraseQuery {
    public static PhraseQuery parsePhrase(Analyzer ana, String field, String query) throws IOException {
        Token tok;
        PhraseQuery pq = new PhraseQuery();
        TokenStream ts = ana.tokenStream(field, (Reader)new StringReader(query));
        boolean haveAdded = false;
        while (null != (tok = ts.next())) {
            Term t = new Term(field, tok.termText());
            pq.add(t);
            haveAdded = true;
        }
        if (!haveAdded) {
            Logs.APP_LOG.info((Object)("phrase tokenization resulted in no tokens: " + query));
            pq.add(new Term(field, query));
        }
        return pq;
    }
}

