/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.mail;

import com.cenqua.fisheye.config1.SmtpType;
import com.cenqua.fisheye.io.NullOutputStream;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.MailMessage;
import java.io.PrintStream;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class Mailer {
    private Session session;
    private InternetAddress from;
    private boolean debug;

    public Mailer(SmtpType cfg) {
        this.reload(cfg);
    }

    public synchronized void reload(final SmtpType cfg) {
        this.session = null;
        Logs.Warnings.warnMailerNotConfiguredJustOnce = true;
        if (cfg == null) {
            Logs.MAIL_LOG.info((Object)"Mail system not configured.");
            return;
        }
        Logs.MAIL_LOG.info((Object)"Initialising mail system.");
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", cfg.getHost());
        Logs.MAIL_LOG.debug((Object)("mail.smtp.host = " + cfg.getHost()));
        if (cfg.isSetPort()) {
            props.setProperty("mail.smtp.port", cfg.getPort().toString());
            Logs.MAIL_LOG.debug((Object)("mail.smtp.port = " + cfg.getPort()));
        }
        try {
            props.setProperty("mail.from", cfg.getFrom());
            Logs.MAIL_LOG.debug((Object)("mail.from = " + cfg.getFrom()));
            this.from = new InternetAddress(cfg.getFrom());
        }
        catch (AddressException e2) {
            Logs.MAIL_LOG.warn((Object)("Invalid SMTP From address '" + cfg.getFrom() + "': " + e2.getMessage()));
        }
        if (cfg.isSetUsername()) {
            final String password = cfg.isSetPassword() ? cfg.getPassword() : "";
            props.put("mail.smtp.auth", "true");
            Logs.MAIL_LOG.debug((Object)"mail.smtp.auth = true");
            Logs.MAIL_LOG.debug((Object)(" username = " + cfg.getUsername()));
            Logs.MAIL_LOG.debug((Object)(" password = " + password));
            this.session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(cfg.getUsername(), password);
                }
            });
        } else {
            this.session = Session.getInstance((Properties)props);
        }
        boolean bl = this.debug = cfg.isSetDebug() && cfg.getDebug();
        if (this.debug) {
            PrintStream debug = new PrintStream(new NullOutputStream()){

                public void println(String string) {
                    Logs.MAIL_LOG.debug((Object)string);
                }
            };
            this.session.setDebug(true);
            this.session.setDebugOut(debug);
        }
    }

    public synchronized boolean isConfigured() {
        return this.session != null;
    }

    public boolean isDebug() {
        return this.debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(MailMessage msg) {
        Session sess;
        Mailer mailer = this;
        synchronized (mailer) {
            if (this.session == null) {
                if (Logs.Warnings.warnMailerNotConfiguredJustOnce) {
                    Logs.Warnings.warnMailerNotConfiguredJustOnce = false;
                    Logs.MAIL_LOG.info((Object)"Tried to send an email, but SMTP not configured.");
                }
                return false;
            }
            sess = this.session;
        }
        try {
            return msg.send(sess, this.from);
        }
        catch (Exception e2) {
            Logs.MAIL_LOG.error((Object)"problem sending email", (Throwable)e2);
            return false;
        }
    }
}

