/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.CommonUtilDAO;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;

public abstract class RepositoryCache
extends BaseRevisionCache {
    private InfinityDbHandle dbh;
    private CommonStringTables commonStringTables;
    private CommonUtilDAO utilDAO;
    private CommonDirInfoDAO dirInfoDAO;
    private LuceneConnection luceneConnection;
    private Analyzer masterAnalyzer;
    private long cacheSerialNumber = 1L;

    public long getCacheSerialNumber() {
        return this.cacheSerialNumber;
    }

    public void setCacheSerialNumber(long cacheSerialNumber) {
        this.cacheSerialNumber = cacheSerialNumber;
    }

    public final void setDatabase(InfinityDbHandle dbh) {
        this.dbh = dbh;
    }

    public InfinityDbHandle getInfDb() {
        return this.dbh;
    }

    public CommonStringTables getCommonStringTables() {
        return this.commonStringTables;
    }

    public void start() throws IOException, DbException {
        this.commonStringTables = new CommonStringTables(this.dbh);
        this.utilDAO = new CommonUtilDAO(this.dbh, this.commonStringTables);
        this.dirInfoDAO = new CommonDirInfoDAO(this.dbh, this.commonStringTables, this.isCaseSensitive());
    }

    public void commit() throws DbException {
        try {
            this.setLastModified(System.currentTimeMillis());
            this.dbh.commit();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void rollback() throws DbException {
        try {
            this.dbh.rollback();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getLastModifiedDate() throws DbException {
        return this.getScanProperty("LastModified", -1L);
    }

    public void touchLastModifiedDate() throws DbException {
        this.setLastModified(System.currentTimeMillis());
    }

    private void setLastModified(long v) throws DbException {
        this.setScanProperty("LastModified", v);
    }

    public synchronized void setScanProperty(String propName, long value) throws DbException {
        this.utilDAO.setLongProperty(propName, value);
    }

    public synchronized long getScanProperty(String propName, long defaultValue) throws DbException {
        long value = this.utilDAO.getLongProperty(propName, defaultValue);
        return value;
    }

    public synchronized boolean hasScanProperty(String propName) throws DbException {
        return this.utilDAO.hasProperty(propName);
    }

    public void setPhase1Revision(long latestPhase1Revision) throws DbException {
        this.setScanProperty("Phase1Slurp", latestPhase1Revision);
    }

    public boolean isInitialScanDone() throws DbException {
        return this.getScanProperty("InitialIndex", -1L) != -1L;
    }

    public void markInitialScanDone() throws DbException {
        this.setScanProperty("InitialIndex", System.currentTimeMillis());
    }

    public long getPhase1Revision() throws DbException {
        return this.getScanProperty("Phase1Slurp", 0L);
    }

    public long getIndexingPhase() throws DbException {
        return this.getScanProperty("IndexingPhase", 0L);
    }

    public void setIndexingPhase(long phase) throws DbException {
        this.setScanProperty("IndexingPhase", phase);
    }

    public void setPhase2Revision(long latestPhase2Revision) throws DbException {
        this.setScanProperty("Phase2Slurp", latestPhase2Revision);
    }

    public long getPhase2Revision() throws DbException {
        return this.getScanProperty("Phase2Slurp", 0L);
    }

    public Path[] listFiles(Path dir) throws DbException {
        Collection<Path> files = this.dirInfoDAO.listFiles(dir);
        return files.toArray(new Path[files.size()]);
    }

    public Path[] listDirs(Path dir) throws DbException {
        Collection<Path> dirs = this.dirInfoDAO.listDirs(dir);
        return dirs.toArray(new Path[dirs.size()]);
    }

    public void setLuceneConnection(LuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public LuceneConnection getLuceneConnection() {
        return this.luceneConnection;
    }

    public Analyzer getMasterAnalyzer() {
        return this.masterAnalyzer;
    }

    public void setMasterAnalyzer(Analyzer masterAnalyzer) {
        this.masterAnalyzer = masterAnalyzer;
    }

    public boolean isDir(Path path) throws DbException {
        return path.isRoot() || this.dirInfoDAO.exists(path);
    }

    public abstract RevInfoKey getKey(int var1) throws DbException;
}

