/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.config1.ResourceCountType;
import com.cenqua.fisheye.config1.ResourcesType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.PingRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingManager {
    public static final Timer REPOSITORY_SCAN_TIMER = new Timer("IncScanner", true);
    private static final ThreadPoolExecutor incrementalExecutePool = PingManager.initExecutePool();
    private static final ThreadPoolExecutor initialExecutePool = PingManager.initExecutePool();

    private static ThreadPoolExecutor initExecutePool() {
        PriorityBlockingQueue<Runnable> queue = new PriorityBlockingQueue<Runnable>(5, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                PingRequest p1 = (PingRequest)o1;
                PingRequest p2 = (PingRequest)o2;
                return p1.getPriority() - p2.getPriority();
            }
        });
        return new ThreadPoolExecutor(1, 1, 1200L, TimeUnit.SECONDS, queue);
    }

    public static void setThreadConfig(ResourcesType threads) {
        if (threads != null) {
            PingManager.setPoolLimits(incrementalExecutePool, threads.getIncrementalIndexThreads());
            PingManager.setPoolLimits(initialExecutePool, threads.getInitialIndexThreads());
        }
    }

    private static void setPoolLimits(ThreadPoolExecutor pool, ResourceCountType config) {
        int min = 1;
        int max = 1;
        if (config != null) {
            min = config.getMin().intValue();
            max = config.getMax().intValue();
        }
        if (min > max) {
            throw new IllegalArgumentException("Thread maximum " + max + " is less than the minimum " + min);
        }
        pool.setCorePoolSize(max);
        pool.setMaximumPoolSize(max);
    }

    public static void performRequest(boolean useInitialThreadPool, PingRequest request) {
        ThreadPoolExecutor pool = useInitialThreadPool ? initialExecutePool : incrementalExecutePool;
        pool.execute(request);
    }

    public static void schedule(TimerTask pingTask, long delay) {
        REPOSITORY_SCAN_TIMER.schedule(pingTask, delay);
    }

    public static List<PingRequest> getPendingRequests(RepositoryHandle handle) {
        ArrayList<PingRequest> result = new ArrayList<PingRequest>();
        PingManager.addPendingRequest(incrementalExecutePool, result, handle);
        PingManager.addPendingRequest(initialExecutePool, result, handle);
        return result;
    }

    private static void addPendingRequest(ThreadPoolExecutor pool, List<PingRequest> result, RepositoryHandle handle) {
        Runnable[] pendingRequests;
        BlockingQueue<Runnable> queue = pool.getQueue();
        for (Runnable runnable : pendingRequests = queue.toArray(new Runnable[queue.size()])) {
            PingRequest request = (PingRequest)runnable;
            if (request.getHandle() != handle) continue;
            result.add(request);
        }
    }
}

