/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.svn.RepositoryWalker;
import com.cenqua.fisheye.svn.SvnCache;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnMessageContext;
import com.cenqua.fisheye.svn.SvnMessageIterator;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.svn.diff.ChangeInfo;
import com.cenqua.fisheye.svn.diff.MessageInfo;
import com.cenqua.fisheye.svn.util.ChangePathUtil;
import com.cenqua.fisheye.svn.util.SvnURLDecoder;
import com.cenqua.fisheye.util.LineCountingInputStream;
import com.cenqua.fisheye.util.LineCountingOutputStream;
import com.cenqua.fisheye.util.Timer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Info;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffChangeSetProcessor {
    private final SvnRepositoryInfo repositoryInfo;
    private final SvnCache cache;
    private final RepositoryStatus statusReporter;
    private SvnThrottledClient client;
    private SvnRevInfoDAO dao;
    private boolean createAsRequired;
    private boolean initialImport = false;

    public DiffChangeSetProcessor(SvnRepositoryInfo repInfo, SvnCache svnCache, RepositoryStatus status) {
        this.repositoryInfo = repInfo;
        this.cache = svnCache;
        this.statusReporter = status;
    }

    public void setDAO(SvnRevInfoDAO dao) {
        this.dao = dao;
    }

    public void setCreateAsRequired(boolean createAsRequired) {
        this.createAsRequired = createAsRequired;
    }

    private void processReplacement(SvnMessageContext context, Path destPhysicalPath) throws DbException {
        this.processDeletion(context, destPhysicalPath, true);
        this.processAddition(context, destPhysicalPath, 'R');
    }

    private void processDeletion(final SvnMessageContext context, final Path physicalPath, final boolean subPathsOnly) throws DbException {
        if (context.getContainingCopy(physicalPath) != null) {
            return;
        }
        final int[] size = new int[1];
        this.dao.visitDirectoryTree(physicalPath, context.getRevision() - 1L, new CommonRevInfoDAO.DirectoryTreeVisitor(){

            public void visit(long subPathId, long subPathLastChangeSetId) throws DbException {
                Path subPath = DiffChangeSetProcessor.this.dao.getPath(subPathId);
                if (subPathsOnly && subPath.equals(physicalPath)) {
                    return;
                }
                if (!context.isCurrentMostSpecific(subPath)) {
                    return;
                }
                size[0] = size[0] + 1;
                SvnRevInfo revision = DiffChangeSetProcessor.this.createFileRevision(context, subPath);
                revision.setDead(true);
                int ancestorRevId = DiffChangeSetProcessor.this.dao.getRevId(subPath, subPathLastChangeSetId);
                String pathContainer = DiffChangeSetProcessor.this.repositoryInfo.getPathMatcher().getContainerId(subPath);
                AncestorLink ancestor = null;
                boolean isTagPath = pathContainer.startsWith("tag:");
                if (ancestorRevId != -1) {
                    ancestor = new AncestorLink(ancestorRevId, 0);
                    revision.setFileType(DiffChangeSetProcessor.this.dao.getFileType(ancestorRevId));
                    DiffChangeSetProcessor.this.setRevisionLineInfo(revision, 0, 0, DiffChangeSetProcessor.this.dao.getLineCount(ancestorRevId));
                } else if (!isTagPath) {
                    Logs.APP_LOG.error((Object)("Unable to find ancestor of " + subPath + "@" + subPathLastChangeSetId + " for delete operation"));
                }
                if (isTagPath) {
                    Path logicalPath = DiffChangeSetProcessor.this.repositoryInfo.getPathMatcher().getLogicalPath(subPath);
                    String tag = DiffChangeSetProcessor.this.repositoryInfo.getPathMatcher().getTag(subPath);
                    int taggedRevid = DiffChangeSetProcessor.this.dao.getTaggedPathRevid(logicalPath, tag, context.getRevision());
                    if (ancestorRevId == -1 && taggedRevid != -1) {
                        revision.setFileType(DiffChangeSetProcessor.this.dao.getFileType(taggedRevid));
                        DiffChangeSetProcessor.this.setRevisionLineInfo(revision, 0, 0, DiffChangeSetProcessor.this.dao.getLineCount(taggedRevid));
                        ancestorRevId = taggedRevid;
                        ancestor = new AncestorLink(ancestorRevId, 0);
                    }
                    revision.createDeletedHunk();
                    DiffChangeSetProcessor.this.insertNewRevision(context, revision, ancestor);
                    DiffChangeSetProcessor.this.dao.removeTag(taggedRevid, tag);
                } else {
                    revision.createDeletedHunk();
                    DiffChangeSetProcessor.this.insertNewRevision(context, revision, ancestor);
                }
            }
        });
        if (this.createAsRequired && !this.initialImport && size[0] == 0) {
            this.createPathForDeletion(context, physicalPath);
        }
    }

    private void createPathForDeletion(SvnMessageContext context, Path physicalPath) throws DbException {
        this.allocateClient();
        long previous = context.getRevision() - 1L;
        Revision.Number prevRev = new Revision.Number(previous);
        try {
            String url = this.repositoryInfo.getPathURL(physicalPath, previous);
            Info2 info = context.getMessageInfo().getInfo(this.client, physicalPath, previous);
            if (info == null) {
                return;
            }
            int fileType = 1;
            if (info.getKind() == 2) {
                DirEntry[] subTree;
                fileType = 2;
                for (DirEntry dirEntry : subTree = this.client.list(url, (Revision)prevRev, (Revision)prevRev, true)) {
                    Path subPath = new Path(physicalPath, dirEntry.getPath());
                    SvnRevInfo subRev = this.createFileRevision(context, subPath);
                    subRev.setFileType(dirEntry.getNodeKind() == 2 ? 2 : 1);
                    subRev.setDead(true);
                    subRev.createDeletedHunk();
                    this.insertNewRevision(context, subRev, null);
                }
            }
            SvnRevInfo revision = this.createFileRevision(context, physicalPath);
            revision.setFileType(fileType);
            revision.setDead(true);
            revision.createDeletedHunk();
            this.insertNewRevision(context, revision, null);
        }
        catch (RepositoryClientException e2) {
            throw new DbException(e2);
        }
        finally {
            this.returnClient();
        }
    }

    private synchronized void allocateClient() throws DbException {
        this.client = this.cache.allocateClient();
    }

    private synchronized void returnClient() {
        this.cache.returnClient(this.client);
        this.client = null;
    }

    private void setPathInfo(SvnRevInfo revision) {
        String branchName;
        boolean isTrunkLike;
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        String containerId = pathMatcher.getContainerId(revision.getPath());
        if (containerId.startsWith("trunk:")) {
            isTrunkLike = true;
            branchName = pathMatcher.getTrunk(revision.getPath());
        } else if (containerId.startsWith("branch:")) {
            isTrunkLike = false;
            branchName = pathMatcher.getBranch(revision.getPath());
        } else if (containerId.startsWith("tag:")) {
            isTrunkLike = false;
            branchName = "";
        } else {
            isTrunkLike = true;
            branchName = "root:";
        }
        revision.setBranch(branchName);
        revision.setTrunkLike(isTrunkLike);
        revision.setLogicalPath(pathMatcher.getLogicalPath(revision.getPath()));
    }

    public void createChangeSet(LogMessage message, MessageInfo messageInfo) throws DbException {
        boolean createRoot;
        Timer timer = new Timer("Creating Changeset " + message.getRevisionNumber());
        SvnMessageContext context = new SvnMessageContext(this.repositoryInfo, message, messageInfo);
        Path rootPath = new Path("/");
        boolean bl = createRoot = this.dao.getLatestPathChange(rootPath) == -1L && context.getMostSpecificChange(rootPath) == null;
        if (createRoot) {
            this.createRootDir(context);
        }
        if (context.hasChangePaths()) {
            long rev = context.getRevision();
            this.statusReporter.setMessage("Creating changeset " + rev);
            Logs.APP_LOG.info((Object)("Creating changeset " + rev));
            SvnMessageIterator i2 = context.getPathIterator();
            while (i2.hasNext()) {
                ChangePath changePath = (ChangePath)i2.next();
                Path physicalPath = messageInfo.getLocalPath(changePath);
                if (!this.repositoryInfo.isPathInRepo(physicalPath)) continue;
                Logs.APP_LOG.debug((Object)("Processing change path" + changePath.getPath() + "@" + rev));
                char action = changePath.getAction();
                Path sourcePhysicalPath = this.repositoryInfo.getLocalPath(changePath.getCopySrcPath(), changePath.getCopySrcRevision());
                boolean sourceAvailableInRepo = this.repositoryInfo.isPathInRepo(sourcePhysicalPath, changePath.getCopySrcRevision());
                try {
                    switch (action) {
                        case 'A': {
                            if (context.isCurrentPathCopy()) {
                                if (!sourceAvailableInRepo) {
                                    this.processAdditionalEntry(physicalPath, context);
                                    break;
                                }
                                this.processCopyAdd(context, sourcePhysicalPath, changePath.getCopySrcRevision(), physicalPath, action);
                                break;
                            }
                            this.processAddition(context, physicalPath, action);
                            break;
                        }
                        case 'M': {
                            this.processModification(context, physicalPath);
                            break;
                        }
                        case 'D': {
                            this.processDeletion(context, physicalPath, false);
                            break;
                        }
                        case 'R': {
                            if (context.isCurrentPathCopy()) {
                                if (sourceAvailableInRepo) {
                                    this.processDeletion(context, physicalPath, true);
                                    this.processCopyAdd(context, sourcePhysicalPath, changePath.getCopySrcRevision(), physicalPath, action);
                                    break;
                                }
                                this.processAdditionalEntry(physicalPath, context);
                                break;
                            }
                            this.processReplacement(context, physicalPath);
                            break;
                        }
                        default: {
                            Logs.APP_LOG.error((Object)("Unknown SVN action on change - " + action + " on path " + changePath.getPath() + ", revision = " + rev));
                            break;
                        }
                    }
                }
                catch (DbException e2) {
                    e2.printStackTrace();
                    Logs.APP_LOG.error((Object)("Unable to process change path \"" + changePath.getPath() + "\" in revision " + context.getRevision()), (Throwable)e2);
                    throw e2;
                }
            }
        }
        this.storeRevProps(context);
        timer.end();
    }

    private void storeRevProps(SvnMessageContext context) throws DbException {
        this.dao.storeRevProps(context.getRevision(), context.getRevProps());
    }

    public void createInitialImport(final SortedMap revisions, long startRevision) throws DbException {
        this.initialImport = true;
        this.statusReporter.setMessage("Importing initial repository state");
        LogMessage importMessage = (LogMessage)revisions.get(revisions.firstKey());
        final SvnMessageContext startContext = new SvnMessageContext(this.repositoryInfo, importMessage, null);
        RepositoryWalker.Visitor visitor = new RepositoryWalker.Visitor(){

            private SvnRevInfo createRev(Path physicalPath, long revision, int nodeKind, PropertyData[] properties) {
                String containerType;
                SvnRevInfo rev = null;
                if (DiffChangeSetProcessor.this.repositoryInfo.isPathInRepo(physicalPath) && !(containerType = DiffChangeSetProcessor.this.repositoryInfo.getPathMatcher().getContainerId(physicalPath)).startsWith("tag:")) {
                    DiffChangeSetProcessor.this.statusReporter.setMessage("Importing " + physicalPath);
                    rev = DiffChangeSetProcessor.this.createFileRevision(startContext, physicalPath);
                    rev.setFileType(nodeKind == 2 ? 2 : 1);
                    rev.setAdded(true);
                    rev.setSVNRevision(revision);
                    rev.setComment("Created by FishEye for initial repository import");
                    rev.setAuthor("no_author");
                    LogMessage specificMessage = (LogMessage)revisions.get(rev.getSvnRevision());
                    if (specificMessage != null) {
                        rev.setDate(specificMessage.getDate().getTime());
                    }
                    DiffChangeSetProcessor.this.setPathInfo(rev);
                    rev.setProperties(properties);
                }
                return rev;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean visitRemoteEntry(SvnThrottledClient client, Path localPath, long revision, Info2 info) throws RepositoryClientException, IOException, DbException {
                if (DiffChangeSetProcessor.this.statusReporter.isStopRequested()) {
                    return false;
                }
                if (!DiffChangeSetProcessor.this.repositoryInfo.isPathInRepo(localPath)) {
                    return false;
                }
                long latestCsid = DiffChangeSetProcessor.this.dao.getLatestPathChange(localPath);
                if (latestCsid != -1L) {
                    return false;
                }
                String tag = DiffChangeSetProcessor.this.repositoryInfo.getPathMatcher().getTag(localPath);
                if (tag != null) {
                    return false;
                }
                String pathURL = DiffChangeSetProcessor.this.repositoryInfo.getPathURL(localPath, revision);
                Revision.Number rev = new Revision.Number(revision);
                PropertyData[] properties = client.properties(pathURL, (Revision)rev, (Revision)rev);
                SvnRevInfo revInfo = this.createRev(localPath, revision, info.getKind(), properties);
                if (revInfo != null) {
                    if (revInfo.getFileType() == 1) {
                        LineCountingOutputStream lcos = new LineCountingOutputStream();
                        try {
                            try {
                                client.streamFileContent(pathURL, (Revision)rev, lcos);
                            }
                            catch (RepositoryClientException e2) {
                                Logs.APP_LOG.warn((Object)("Unable to get initial content for " + localPath), (Throwable)e2);
                            }
                            DiffChangeSetProcessor.this.setRevisionLineInfo(revInfo, lcos.getLineCount(), lcos.getLineCount(), 0);
                        }
                        catch (IOException e2) {
                            Logs.APP_LOG.warn((Object)("Unable to get initial content for " + localPath), (Throwable)e2);
                        }
                        finally {
                            IOHelper.close(lcos);
                        }
                    }
                    revInfo.createAdditionHunk();
                    DiffChangeSetProcessor.this.insertNewRevision(startContext, revInfo, null);
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean visitWorkingCopyEntry(SvnThrottledClient client, File wcFile, Info fileInfo, long revision) throws RepositoryClientException, IOException, DbException {
                Path localPath;
                if (DiffChangeSetProcessor.this.statusReporter.isStopRequested()) {
                    return false;
                }
                try {
                    String serverPath = fileInfo.getUrl().substring(fileInfo.getRepository().length());
                    serverPath = SvnURLDecoder.decode(serverPath, "UTF-8");
                    localPath = DiffChangeSetProcessor.this.repositoryInfo.getLocalPath(serverPath, revision);
                }
                catch (UnsupportedEncodingException e2) {
                    throw new DbException(e2);
                }
                PropertyData[] properties = client.properties(wcFile.getAbsolutePath());
                SvnRevInfo svnRevInfo = this.createRev(localPath, revision, fileInfo.getNodeKind(), properties);
                if (svnRevInfo != null) {
                    if (fileInfo.getNodeKind() == 1) {
                        FileInputStream fis = null;
                        LineCountingInputStream lcis = null;
                        try {
                            fis = new FileInputStream(wcFile);
                            lcis = new LineCountingInputStream(fis);
                            lcis.readFully();
                            DiffChangeSetProcessor.this.setRevisionLineInfo(svnRevInfo, lcis.getLineCount(), lcis.getLineCount(), 0);
                        }
                        catch (IOException e3) {
                            try {
                                Logs.APP_LOG.warn((Object)("Unable to get content info for working copy file: " + wcFile.getAbsolutePath()), (Throwable)e3);
                            }
                            catch (Throwable throwable) {
                                IOHelper.close(fis);
                                IOHelper.close(lcis);
                                throw throwable;
                            }
                            IOHelper.close(fis);
                            IOHelper.close(lcis);
                        }
                        IOHelper.close(fis);
                        IOHelper.close(lcis);
                    }
                    svnRevInfo.createAdditionHunk();
                    DiffChangeSetProcessor.this.insertNewRevision(startContext, svnRevInfo, null);
                }
                return true;
            }
        };
        this.allocateClient();
        try {
            RepositoryWalker walker = new RepositoryWalker(this.repositoryInfo, this.client, startRevision - 1L);
            walker.setSkipTags(true);
            walker.walkDir(new Path("/"), visitor);
        }
        catch (RepositoryClientException e2) {
            throw new DbException(e2);
        }
        catch (IOException e3) {
            throw new DbException(e3);
        }
        finally {
            this.returnClient();
            this.initialImport = false;
        }
    }

    private void createRootDir(SvnMessageContext context) throws DbException {
        Logs.APP_LOG.debug((Object)"Creating repository root");
        int revid = (int)this.dao.getLatestPathChange(new Path("/"));
        if (revid == -1) {
            SvnRevInfo rootRev = this.createFileRevision(context, new Path("/"));
            rootRev.setFileType(2);
            rootRev.setAdded(true);
            this.insertNewRevision(context, rootRev, null);
        }
    }

    private void processCopyAdd(final SvnMessageContext context, final Path sourcePath, long sourceChangeSetId, final Path destPath, final char action) throws DbException {
        final SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        this.dao.visitDirectoryTree(sourcePath, sourceChangeSetId, new CommonRevInfoDAO.DirectoryTreeVisitor(){

            public void visit(long subPathId, long subPathChangeSetId) throws DbException {
                Path sourceSubPath = DiffChangeSetProcessor.this.dao.getPath(subPathId);
                Path relativePath = sourceSubPath.getRelativePath(sourcePath);
                Path destSubPath = new Path(destPath, relativePath.toString());
                if (context.isCurrentMostSpecific(destSubPath)) {
                    String tag = pathMatcher.getTag(destSubPath);
                    boolean applyTag = false;
                    if (tag != null) {
                        Path srcLogicalPath = pathMatcher.getLogicalPath(sourceSubPath);
                        Path destLogicalPath = pathMatcher.getLogicalPath(destSubPath);
                        if (destLogicalPath.equals(srcLogicalPath)) {
                            applyTag = true;
                        }
                    }
                    if (applyTag) {
                        DiffChangeSetProcessor.this.applyTag(context, sourceSubPath, subPathChangeSetId, destSubPath, action);
                    } else {
                        DiffChangeSetProcessor.this.processCopyPath(context, sourceSubPath, subPathChangeSetId, destSubPath, action);
                    }
                }
            }
        });
    }

    private void applyTag(SvnMessageContext context, Path sourcePath, long sourceChangeSetId, Path destPath, char action) throws DbException {
        long pathCSID;
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        Path tagRoot = pathMatcher.getTagRoot(destPath);
        String tag = pathMatcher.getTag(destPath);
        this.updateTagRoot(context, tagRoot, tag);
        if (!destPath.equals(tagRoot) && (pathCSID = this.dao.getLatestPathChange(destPath)) != -1L) {
            this.processCopyPath(context, sourcePath, sourceChangeSetId, destPath, action);
        }
        this.dao.storeTagRevision(tag, destPath, context.getRevision(), sourcePath, sourceChangeSetId);
        int taggedRevId = this.dao.getRevId(sourcePath, sourceChangeSetId);
        this.dao.addTag(taggedRevId, tag);
    }

    private void updateTagRoot(SvnMessageContext context, Path tagRoot, String tag) throws DbException {
        int tagRootRevid;
        long latestCSID = this.dao.getLatestPathChange(tagRoot);
        if (latestCSID == context.getRevision()) {
            return;
        }
        SvnRevInfo tagRootEntry = this.createFileRevision(context, tagRoot);
        tagRootEntry.setFileType(2);
        AncestorLink tagRootAncestor = null;
        if (latestCSID != -1L && !this.dao.isDeleted(tagRootRevid = this.dao.getRevId(tagRoot, latestCSID))) {
            tagRootAncestor = new AncestorLink(tagRootRevid, 0);
        }
        if (tagRootAncestor == null) {
            tagRootEntry.setAdded(true);
        }
        int rootRevId = this.dao.insertNew(tagRootEntry, tagRootAncestor, this.repositoryInfo.isStoreDiffs());
        this.dao.addTag(rootRevId, tag);
    }

    private void processCopyPath(SvnMessageContext context, Path sourcePath, long sourceChangeSetId, Path destPath, char action) throws DbException {
        AncestorLink ancestor;
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        String branch = pathMatcher.getBranch(destPath);
        boolean toTrunk = false;
        if (branch == null && pathMatcher.getContainerId(destPath).startsWith("trunk:")) {
            branch = pathMatcher.getTrunk(destPath);
            toTrunk = true;
        }
        int sourceRevId = this.dao.getRevId(sourcePath, sourceChangeSetId);
        Path srcLogicalPath = pathMatcher.getLogicalPath(sourcePath);
        Path destLogicalPath = pathMatcher.getLogicalPath(destPath);
        if (sourceRevId == -1) {
            Logs.APP_LOG.error((Object)("Unable to get revid for source revision + " + sourcePath + "@" + sourceChangeSetId));
            Logs.APP_LOG.error((Object)("Not creating item at " + destPath + "@" + context.getRevision()));
            return;
        }
        SvnRevInfo revision = this.createFileRevision(context, destPath);
        String serverSourcePath = this.repositoryInfo.getServerPath(sourcePath, sourceChangeSetId);
        if (branch != null && destLogicalPath.equals(srcLogicalPath) && !toTrunk) {
            ancestor = new AncestorLink(sourceRevId, 1);
        } else if (context.isPathMoved(serverSourcePath)) {
            revision.setMove(true);
            ancestor = new AncestorLink(sourceRevId, 3);
        } else {
            revision.setCopy(true);
            ancestor = new AncestorLink(sourceRevId, 2);
        }
        revision.setFileType(this.dao.getFileType(sourceRevId));
        int srcLineCount = this.dao.getLineCount(sourceRevId);
        ChangeInfo changeInfo = context.getChangeInfo(destPath);
        if (changeInfo != null) {
            revision.setHunks(changeInfo.getHunks());
            int previousRevid = -1;
            long previousCSID = this.dao.getLatestPathChange(destPath);
            if (previousCSID != -1L) {
                previousRevid = this.dao.getRevId(destPath, previousCSID);
            }
            if (previousRevid != -1 && action == 'R') {
                int prevLineCount = this.dao.getLineCount(previousRevid);
                int lineCount = changeInfo.isDiffGenerated() ? prevLineCount + changeInfo.getNumAdded() - changeInfo.getNumRemoved() : changeInfo.getNumAdded();
                this.setRevisionLineInfo(revision, lineCount, lineCount, prevLineCount);
                this.setRevisionProperties(revision, changeInfo, this.dao.loadSvnProperties(previousRevid));
            } else {
                revision.setAdded(true);
                this.setRevisionLineInfo(revision, changeInfo.getNumAdded(), changeInfo.getNumAdded(), 0);
                this.setRevisionProperties(revision, changeInfo, null);
                revision.createAdditionHunk();
            }
        } else {
            revision.setAdded(true);
            revision.setProperties(this.dao.loadSvnProperties(sourceRevId));
            this.setRevisionLineInfo(revision, srcLineCount, srcLineCount, 0);
            revision.createAdditionHunk();
        }
        this.insertNewRevision(context, revision, ancestor);
    }

    private void processAdditionalEntry(Path destPath, SvnMessageContext context) throws DbException {
        this.allocateClient();
        try {
            DirEntry[] entries;
            boolean isDir;
            String destURL = this.repositoryInfo.getPathURL(destPath, context.getRevision());
            Revision.Number rev = new Revision.Number(context.getRevision());
            Info2 info = context.getMessageInfo().getInfo(this.client, destPath);
            boolean bl = isDir = info.getKind() == 2;
            if (isDir) {
                boolean dirExists = false;
                long dirCSID = this.dao.getLatestPathChangeUpto(destPath, context.getRevision());
                if (dirCSID != -1L) {
                    int revid = this.dao.getRevId(destPath, dirCSID);
                    boolean bl2 = dirExists = !this.dao.isDeleted(revid);
                }
                if (!dirExists) {
                    this.processAddition(context, destPath, 'A');
                }
            }
            for (DirEntry entry : entries = this.client.list(destURL, (Revision)rev, (Revision)rev, true)) {
                Path entryPath = isDir ? new Path(destPath, entry.getPath()) : new Path(destPath.getParent(), entry.getPath());
                if (!context.isCurrentMostSpecific(entryPath)) continue;
                this.processAddition(context, entryPath, 'A');
            }
        }
        catch (RepositoryClientException e2) {
            throw new DbException(e2);
        }
        finally {
            this.returnClient();
        }
    }

    private void processAddition(SvnMessageContext context, Path physicalPath, char action) throws DbException {
        if (!context.hasMessageInfo()) {
            throw new DbException("Unable to get diff information for revision " + context.getRevision());
        }
        ChangeInfo info = context.getChangeInfo(physicalPath);
        SvnRevInfo revision = this.createFileRevision(context, physicalPath);
        revision.setAdded(true);
        AncestorLink ancestorLink = null;
        int ancestorRevid = -1;
        long previousRevision = this.dao.getLatestPathChange(physicalPath);
        if (previousRevision != -1L && (ancestorRevid = this.dao.getRevId(physicalPath, previousRevision)) != -1) {
            if (!this.dao.isDeleted(ancestorRevid)) {
                action = (char)82;
            }
            ancestorLink = new AncestorLink(ancestorRevid, 0);
        }
        if (action == 'R') {
            if (info == null) {
                if (ancestorRevid == -1) {
                    revision.setFileType(2);
                } else {
                    revision.setFileType(this.dao.getFileType(ancestorRevid));
                    revision.setLineCount(this.lineCount(ancestorRevid));
                    revision.setProperties(this.dao.loadSvnProperties(ancestorRevid));
                    revision.createAdditionHunk();
                }
            } else if (ancestorRevid == -1) {
                this.setRevisionLineInfo(revision, info.getNumAdded(), info.getNumAdded(), 0);
                this.setRevisionProperties(revision, info, null);
                revision.setFileType(info.isFileDiff() ? 1 : 2);
                if (info.getHunks() == null || info.getHunks().isEmpty()) {
                    revision.createAdditionHunk();
                } else {
                    revision.setHunks(info.getHunks());
                }
            } else {
                int previousLineCount = this.dao.getLineCount(ancestorRevid);
                int lineCount = info.isDiffGenerated() ? previousLineCount + info.getNumAdded() - info.getNumRemoved() : info.getNumAdded();
                this.setRevisionLineInfo(revision, lineCount, lineCount, previousLineCount);
                this.setRevisionProperties(revision, info, this.dao.loadSvnProperties(ancestorRevid));
                revision.createReplaceHunk(previousLineCount);
                revision.setFileType(this.dao.getFileType(ancestorRevid));
            }
        } else if (info != null && info.isFileDiff()) {
            this.setRevisionLineInfo(revision, info.getNumAdded() - info.getNumRemoved(), info.getNumAdded(), info.getNumRemoved());
            this.setRevisionProperties(revision, info, null);
            revision.createAdditionHunk();
        } else {
            revision.createAdditionHunk();
            revision.setFileType(2);
            if (info != null) {
                revision.setProperties(info.getUpdatedProperties());
            }
        }
        this.insertNewRevision(context, revision, ancestorLink);
    }

    private int lineCount(int ancestorRevid) throws DbException {
        return this.dao.getLineCount(ancestorRevid);
    }

    private void setRevisionLineInfo(SvnRevInfo revision, int lineCount, int numAdded, int numRemoved) {
        revision.setLineCount(lineCount);
        revision.setLinesAdded(numAdded);
        revision.setLinesRemoved(numRemoved);
    }

    private SvnRevInfo createFileRevision(SvnMessageContext context, Path physicalPath) {
        SvnRevInfo revision = new SvnRevInfo();
        revision.setSVNRevision(context.getRevision());
        revision.setAuthor(context.getAuthor());
        revision.setDate(context.getDate());
        revision.setComment(context.getMessage());
        revision.setPath(physicalPath);
        this.setPathInfo(revision);
        revision.setFileType(1);
        return revision;
    }

    private void processModification(SvnMessageContext context, Path physicalPath) throws DbException {
        if (!context.hasMessageInfo()) {
            throw new DbException("Unable to get diff information for revision " + context.getRevision());
        }
        SvnRevInfo revision = this.createFileRevision(context, physicalPath);
        revision.setModify(true);
        int ancestorRevid = -1;
        AncestorLink ancestorLink = null;
        boolean newlyCreated = false;
        long previousRevision = this.dao.getLatestPathChange(physicalPath);
        if (previousRevision == -1L) {
            List<ChangePath> applicableChanges = context.getApplicableChangePaths(physicalPath);
            applicableChanges.remove(context.getCurrentPath());
            ChangePath mostSpecific = ChangePathUtil.getMostSpecific(applicableChanges);
            if (mostSpecific == null) {
                if (this.createAsRequired) {
                    if (!this.initialImport) {
                        this.fillInRevisionInfo(revision);
                        newlyCreated = true;
                    }
                } else {
                    Logs.APP_LOG.error((Object)("Modification found to " + revision.getRevInfoKey() + " with no previous revision"));
                }
            } else {
                revision.setModify(false);
                revision.setAdded(true);
            }
        } else {
            ancestorRevid = this.dao.getRevId(physicalPath, previousRevision);
            if (ancestorRevid != -1) {
                ancestorLink = new AncestorLink(ancestorRevid, 0);
            }
        }
        if (!newlyCreated) {
            ChangeInfo info = context.getChangeInfo(physicalPath);
            int ancestorLineCount = 0;
            HashMap<String, String> ancestorProperties = new HashMap();
            if (ancestorRevid != -1) {
                ancestorLineCount = this.dao.getLineCount(ancestorRevid);
                ancestorProperties = this.dao.loadSvnProperties(ancestorRevid);
                revision.setFileType(this.dao.getFileType(ancestorRevid));
            }
            if (info != null) {
                int lineCount = ancestorLineCount + info.getNumAdded() - info.getNumRemoved();
                this.setRevisionLineInfo(revision, lineCount, info.getNumAdded(), info.getNumRemoved());
                this.setRevisionProperties(revision, info, ancestorProperties);
                if (revision.isAdded()) {
                    revision.createAdditionHunk();
                } else {
                    revision.setHunks(info.getHunks());
                }
                if (!info.isFileDiff()) {
                    revision.setFileType(2);
                }
            } else {
                this.setRevisionLineInfo(revision, ancestorLineCount, 0, 0);
                revision.setProperties(this.dao.loadSvnProperties(ancestorRevid));
            }
            if (revision.isBinary() && ancestorLineCount != 0) {
                this.setRevisionLineInfo(revision, 0, 0, ancestorLineCount);
                revision.createDeletedHunk();
            }
        }
        this.insertNewRevision(context, revision, ancestorLink);
    }

    public void fillInRevisionInfo(SvnRevInfo revision) throws DbException {
        this.allocateClient();
        try {
            String url = this.cache.getContentURL(this.client, revision.getPath(), revision.getSvnRevision());
            Revision.Number rev = new Revision.Number(revision.getSvnRevision());
            Info2 info = null;
            try {
                Info2[] infoArray = this.client.info2(url, (Revision)rev, (Revision)rev, false);
                if (infoArray.length == 0) {
                    Logs.APP_LOG.error((Object)("Unable to get file node info for " + revision.getRevInfoKey()));
                } else {
                    info = infoArray[0];
                }
            }
            catch (RepositoryClientException e2) {
                Logs.APP_LOG.debug((Object)"Exception getting Info for fill in rev - probably a symbolic link", (Throwable)e2);
            }
            if (info != null) {
                revision.setFileType(info.getKind() == 2 ? 2 : 1);
                if (revision.getFileType() == 1) {
                    RevInfoKey key = revision.getRevInfoKey();
                    int lineCount = this.getFileSize(key);
                    revision.setLineCount(lineCount);
                    revision.setLinesAdded(lineCount);
                    revision.setLinesRemoved(0);
                    revision.createAdditionHunk();
                }
            }
            PropertyData[] properties = this.client.properties(url, (Revision)rev, (Revision)rev);
            revision.setProperties(properties);
        }
        catch (IOException e3) {
            throw new DbException(e3);
        }
        catch (RepositoryClientException e4) {
            throw new DbException(e4);
        }
        finally {
            this.returnClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFileSize(RevInfoKey key) throws IOException, DbException, RepositoryClientException {
        int lineCount = 0;
        LineCountingInputStream lcis = null;
        File contentFile = File.createTempFile("filesize", null, this.repositoryInfo.getRepoTempDir());
        try {
            long revNumber = Long.parseLong(key.getRev());
            if (this.cache.exportContent(key.getPath(), contentFile, revNumber)) {
                FileInputStream fis = new FileInputStream(contentFile);
                lcis = new LineCountingInputStream(new BufferedInputStream(fis));
                lcis.readFully();
                lcis.close();
                lineCount = lcis.getLineCount();
            } else {
                Logs.APP_LOG.warn((Object)("Unable to determine file size for " + key));
            }
        }
        finally {
            IOHelper.close(lcis);
            IOHelper.deleteFile(contentFile);
        }
        return lineCount;
    }

    private int insertNewRevision(SvnMessageContext context, SvnRevInfo revision, AncestorLink ancestorLink) throws DbException {
        int revid;
        int existingRevid = this.dao.getPureRevId(revision.getPath(), revision.getSvnRevision());
        if (existingRevid != -1) {
            Logs.APP_LOG.error((Object)("Attempting to insert a revison which already exists for " + revision.getRevInfoKey()));
            return -1;
        }
        SvnLogicalPathMatcher pathMatcher = this.repositoryInfo.getPathMatcher();
        if (!revision.isDead() && !this.verifyParentDirs(context, revision.getPath())) {
            if (this.createAsRequired) {
                if (!this.initialImport) {
                    this.createParentDirs(context, revision.getPath());
                }
            } else {
                Logs.APP_LOG.error((Object)("Not inserting revision " + revision.getPath() + "@" + revision.getSvnRevision() + " because a parent directory is missing"));
                return -1;
            }
        }
        if (pathMatcher.getContainerId(revision.getPath()).startsWith("tag:")) {
            String tag = pathMatcher.getTag(revision.getPath());
            if (ancestorLink == null) {
                revision.setBranch("tag:" + tag);
            } else {
                int ancestorRevId = ancestorLink.getRevid();
                SvnRevInfo ancestorRev = this.dao.loadRevision(ancestorRevId);
                if (ancestorRev == null) {
                    Logs.APP_LOG.warn((Object)("Unable to find ancestor for " + revision.getRevInfoKey()));
                    revision.setBranch("tag:" + tag);
                } else if (ancestorRev.getPath().equals(revision.getPath())) {
                    revision.setBranch(ancestorRev.getBranch());
                } else {
                    revision.setBranch("tag:" + tag);
                    ancestorLink = new AncestorLink(ancestorLink.getRevid(), 1);
                }
            }
            revid = this.dao.insertNew(revision, ancestorLink, this.repositoryInfo.isStoreDiffs());
            this.dao.addTag(revid, tag);
        } else {
            revid = this.dao.insertNew(revision, ancestorLink, this.repositoryInfo.isStoreDiffs());
        }
        return revid;
    }

    private void createParentDirs(SvnMessageContext context, Path path) throws DbException {
        Path parent = path.getParent();
        String[] components = parent.getComponents();
        Path parentPath = new Path();
        for (String component : components) {
            ChangePath bestChange;
            long csid = this.dao.getLatestPathChange(parentPath = new Path(parentPath, component));
            if (csid != -1L || (bestChange = context.getMostSpecificChange(parentPath)) != null) continue;
            SvnRevInfo dir = this.createFileRevision(context, parentPath);
            dir.setFileType(2);
            this.insertNewRevision(context, dir, null);
        }
    }

    private boolean verifyParentDirs(SvnMessageContext context, Path path) throws DbException {
        Path parent = path.getParent();
        while (!parent.isRoot()) {
            long csid = this.dao.getLatestPathChange(parent);
            ChangePath bestChange = context.getMostSpecificChange(parent);
            if (csid == -1L ? bestChange == null || bestChange.getAction() == 'D' : bestChange != null && bestChange.getAction() == 'D') {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    private void setRevisionProperties(SvnRevInfo revision, ChangeInfo info, Map<String, String> ancestorProperties) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (ancestorProperties != null) {
            properties.putAll(ancestorProperties);
        }
        for (String key : info.getRemovedProperties()) {
            properties.remove(key);
        }
        Map<String, String> updatedProperties = info.getUpdatedProperties();
        for (Map.Entry<String, String> entry : updatedProperties.entrySet()) {
            String key = entry.getKey();
            properties.put(key, entry.getValue());
        }
        revision.setProperties(properties);
    }

    public synchronized void requestStop() {
        if (this.client != null) {
            this.client.cancel();
        }
    }
}

