/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.logging.Logs;
import org.tigris.subversion.javahl.PromptUserPassword3;

public class SvnPasswordSupplier
implements PromptUserPassword3 {
    private String username;
    private String password;

    public SvnPasswordSupplier(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public boolean prompt(String realm, String user, boolean maySave) {
        Logs.APP_LOG.debug((Object)("prompting for realm: " + realm + " with username: " + user + ", maySave = " + maySave));
        if (this.username == null) {
            throw new RuntimeException("Subversion username and password required for " + realm + " but not provided in config.");
        }
        if (!this.username.equals(user)) {
            Logs.APP_LOG.debug((Object)("System prompted for user " + user + ", which does not match configured username " + this.username));
        }
        return true;
    }

    public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
        Logs.APP_LOG.debug((Object)("prompting for realm: " + realm + " with question: " + question + ", show = " + showAnswer + " maySave = " + maySave));
        return null;
    }

    public boolean userAllowedSave() {
        Logs.APP_LOG.debug((Object)"querying userAllowedSave");
        return false;
    }

    public int askTrustSSLServer(String info, boolean allowPermanently) {
        Logs.APP_LOG.debug((Object)("asking for ssl server trust level: " + info));
        return 2;
    }

    public boolean prompt(String realm, String user) {
        Logs.APP_LOG.debug((Object)("prompting for realm: " + realm + " with username: " + user));
        return false;
    }

    public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
        Logs.APP_LOG.debug((Object)("prompting for realm: " + realm + " with question: " + question));
        return yesIsDefault;
    }

    public String askQuestion(String realm, String question, boolean showAnswer) {
        Logs.APP_LOG.debug((Object)("prompting for realm: " + realm + " with question: " + question + ", show = " + showAnswer));
        return null;
    }

    public String getUsername() {
        Logs.APP_LOG.debug((Object)"Getting username");
        return this.username;
    }

    public String getPassword() {
        Logs.APP_LOG.debug((Object)"Getting password");
        return this.password;
    }
}

