/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.FileUtils;
import com.cenqua.fisheye.util.Throttle;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.javahl.SVNClientInterface;

public class Tester {
    private SvnThrottledClient client = new SvnThrottledClient("Tester", new Throttle(), (SVNClientInterface)new SVNClient(), 600000L);
    private static final long TIMEOUT = 600000L;

    public static void main(String[] args) {
        try {
            Logger logger = Logger.getRootLogger();
            PatternLayout layout = new PatternLayout("%-5p - %m%n");
            ConsoleAppender appender = new ConsoleAppender((Layout)layout, "System.out");
            logger.addAppender((Appender)appender);
            logger.setLevel(Level.ALL);
            Tester tester = new Tester();
            tester.doTest(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    private void doTest(String[] args) {
        String operation = args[0];
        if (operation.equals("diff")) {
            this.doDiffTest(args);
        } else {
            System.err.println("Unknown operation " + operation);
        }
    }

    private void doDiffTest(String[] args) {
        long revision = Long.valueOf(args[1]);
        String url = args[2];
        Revision.Number r1 = new Revision.Number(revision - 1L);
        Revision.Number r2 = new Revision.Number(revision);
        try {
            File outputDir = new File("result");
            FileUtils.deleteTree(outputDir);
            outputDir.mkdirs();
            this.client.diff(url, (Revision)r2, (Revision)r1, (Revision)r2, "result/output.txt", true, true, true, false);
        }
        catch (RepositoryClientException e2) {
            e2.printStackTrace();
        }
    }
}

