/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RepositoryInfo;
import com.cenqua.fisheye.svn.SvnAction;
import com.cenqua.fisheye.svn.SvnMessageIterator;
import java.util.ArrayList;
import java.util.List;
import org.tigris.subversion.javahl.ChangePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePathUtil {
    public static boolean isBinaryMimeType(String mimeType) {
        boolean binary = false;
        if (mimeType != null) {
            binary = !mimeType.toLowerCase().startsWith("text/");
        }
        return binary;
    }

    public static boolean isSubPath(String path, String subPath) {
        if (subPath.equals(path)) {
            return true;
        }
        int plen = path.length();
        int slen = subPath.length();
        if (plen == 0) {
            return false;
        }
        if (slen < plen || !subPath.substring(0, plen).equals(path)) {
            return false;
        }
        if (path.charAt(plen - 1) == '/') {
            return true;
        }
        return subPath.charAt(plen) == '/';
    }

    public static List<ChangePath> getApplicableChangePaths(ChangePath[] changePaths, String serverPath) {
        ArrayList<ChangePath> result = new ArrayList<ChangePath>();
        SvnMessageIterator i2 = new SvnMessageIterator(changePaths);
        while (i2.hasNext()) {
            ChangePath changePath = (ChangePath)i2.next();
            if (!ChangePathUtil.isSubPath(changePath.getPath(), serverPath)) continue;
            result.add(changePath);
        }
        return result;
    }

    public static ChangePath getMostSpecific(List<ChangePath> changePaths) {
        ChangePath mostSpecific = null;
        for (ChangePath changePath : changePaths) {
            if (mostSpecific != null && changePath.getPath().length() <= mostSpecific.getPath().length()) continue;
            mostSpecific = changePath;
        }
        return mostSpecific;
    }

    public static String getCommonRoot(List<ChangePath> changePaths) {
        Path commonRoot = null;
        for (ChangePath changePath : changePaths) {
            Path path = new Path(changePath.getPath());
            if (commonRoot == null) {
                commonRoot = path;
                continue;
            }
            commonRoot = commonRoot.getCommonRoot(path);
        }
        return commonRoot != null ? commonRoot.getPath() : null;
    }

    public static List<ChangePath> getRequiredDiffs(RepositoryInfo repositoryInfo, ChangePath[] changePaths, long revision) {
        ArrayList<ChangePath> requiredDiffs = new ArrayList<ChangePath>();
        for (ChangePath changePath : changePaths) {
            boolean sourceInfoInRepository;
            char action = changePath.getAction();
            Path localPath = repositoryInfo.getLocalPath(changePath.getPath(), revision);
            if (!repositoryInfo.isPathInRepo(localPath) || action == 'D') continue;
            if (changePath.getCopySrcPath() != null) {
                Path sourcePath = repositoryInfo.getLocalPath(changePath.getCopySrcPath(), changePath.getCopySrcRevision());
                sourceInfoInRepository = repositoryInfo.isPathInRepo(sourcePath);
            } else {
                sourceInfoInRepository = false;
            }
            if (sourceInfoInRepository || !SvnAction.isDiffableAction(action)) continue;
            requiredDiffs.add(changePath);
        }
        return requiredDiffs;
    }
}

