/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeClassLoader;
import com.cenqua.fisheye.FishEyeCtl;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.SvnConfigType;
import com.cenqua.fisheye.logging.Log4jHandler;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Logger;
import org.tigris.subversion.javahl.SVNClient;

public class SvnLoader {
    private static boolean loaded = false;
    private static final String JAVAHL_INTERFACE = "org/tigris/subversion/javahl/SVNClientInterface.class";

    public static void checkLoaded() throws ConfigException {
        if (loaded) {
            return;
        }
        SvnLoader.onLoaded();
        loaded = true;
    }

    private static void onLoaded() throws ConfigException {
        try {
            Logger svnkitLogger = Logger.getLogger("javasvn");
            svnkitLogger.addHandler(new Log4jHandler(Logs.SVNKIT_LOG));
            svnkitLogger = Logger.getLogger("svnkit");
            svnkitLogger.addHandler(new Log4jHandler(Logs.SVNKIT_LOG));
            System.setProperty("svnkit.symlinks", "false");
            System.setProperty("file.encoding", "UTF-8");
            String version = SVNClient.version();
            Logs.APP_LOG.info((Object)("Loaded svn-javahl, version: " + version));
            Logs.APP_LOG.info((Object)("javaHL loaded from " + SvnLoader.getResourceSource(SVNClient.class)));
            SvnLoader.dumpSvnLoader();
        }
        catch (Throwable e2) {
            Logs.CONSOLE.warn((Object)"Could not load svn-javahl", e2);
            throw new ConfigException("Could not load svn-javahl: " + e2.getClass().getName() + "-" + e2.getMessage(), e2);
        }
    }

    private static void dumpSvnLoader() {
        ClassLoader loader = SVNClient.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            URL[] urls = urlLoader.getURLs();
            StringBuilder loaderPath = new StringBuilder();
            for (URL url : urls) {
                loaderPath.append(url.toString()).append(':');
            }
            Logs.APP_LOG.info((Object)("SVN Loader Path is " + loaderPath.toString()));
        } else {
            Logs.APP_LOG.info((Object)("SVN Loader is not a URLClassLoader, it is a " + loader.getClass().getName()));
        }
    }

    private static String getResourceSource(Class c2) {
        String resource = c2.getName().replace('.', '/') + ".class";
        return SvnLoader.getResourceSource(c2.getClassLoader(), resource);
    }

    private static String getResourceSource(ClassLoader loader, String resource) {
        URL url = loader == null ? ClassLoader.getSystemResource(resource) : loader.getResource(resource);
        if (url != null) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                return u.substring(4, pling);
            }
            if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                return u.substring(0, tail);
            }
        }
        return null;
    }

    private static void testSvnLibrary() {
        String specifiedLibraryName = System.getProperty("subversion.native.library");
        if (specifiedLibraryName != null) {
            try {
                System.load(specifiedLibraryName);
                Logs.APP_LOG.debug((Object)("SVN Library loaded successfully from " + specifiedLibraryName));
                return;
            }
            catch (UnsatisfiedLinkError ex) {
                Logs.APP_LOG.debug((Object)("Unable to load specified library: " + specifiedLibraryName), (Throwable)ex);
            }
        }
        try {
            System.loadLibrary("svnjavahl-1");
            Logs.APP_LOG.debug((Object)"SVN Library loaded successfully from svnjavahl-1");
        }
        catch (UnsatisfiedLinkError ex) {
            Logs.APP_LOG.debug((Object)"Unable to load library as svnjavahl-1", (Throwable)ex);
            try {
                System.loadLibrary("libsvnjavahl-1");
                Logs.APP_LOG.debug((Object)"SVN Library loaded successfully from libsvnjavahl-1");
            }
            catch (UnsatisfiedLinkError e2) {
                Logs.APP_LOG.debug((Object)"Unable to load library as libsvnjavahl-1", (Throwable)ex);
                System.loadLibrary("svnjavahl");
                Logs.APP_LOG.debug((Object)"SVN Library loaded successfully from svnjavahl");
            }
        }
    }

    public static void setup(SvnConfigType cfg) {
        boolean javaHLAvailable;
        boolean useInbuiltJar = true;
        boolean bl = javaHLAvailable = SvnLoader.getResourceSource(SvnLoader.class.getClassLoader(), JAVAHL_INTERFACE) != null;
        if (cfg != null) {
            if (cfg.isSetJar()) {
                if (javaHLAvailable) {
                    Logs.APP_LOG.info((Object)"Ignoring svn configuration for JavaHL jar location as JavaHL found in classpath");
                } else {
                    SvnLoader.setupJar(cfg.getJar());
                }
                useInbuiltJar = false;
            }
            if (cfg.isSetJnilib()) {
                useInbuiltJar = false;
                Logs.APP_LOG.debug((Object)("Setting Subversion library location to " + cfg.getJnilib()));
                System.setProperty("subversion.native.library", cfg.getJnilib());
            }
        }
        if (useInbuiltJar) {
            if (javaHLAvailable) {
                Logs.APP_LOG.info((Object)"JavaHL found in classpath");
            } else {
                Logs.APP_LOG.info((Object)"Loading included SvnKit from lib/svn");
                SvnLoader.setupJarsFromDir(new File(AppConfig.getAppHome(), "lib/svn"));
            }
        }
    }

    private static void setupJarsFromDir(File dir) {
        if (!dir.isDirectory()) {
            Logs.APP_LOG.error((Object)("could not find SVN lib directory " + dir));
            return;
        }
        FishEyeClassLoader fcl = FishEyeCtl.CLASSLOADER;
        if (fcl == null) {
            Logs.APP_LOG.error((Object)"Internal FishEye problem: could not load svn jar because we couldn't find our classloader.");
            return;
        }
        try {
            fcl.addJarsFromDir(dir);
            Logs.APP_LOG.info((Object)("Loaded svn jar from directory " + dir));
        }
        catch (MalformedURLException e2) {
            Logs.APP_LOG.error((Object)"problem loading jar", (Throwable)e2);
        }
    }

    private static void setupJar(String jar) {
        File jarfile = new File(jar);
        if (!jarfile.isFile()) {
            Logs.APP_LOG.error((Object)("SVN jar does not exist: " + jarfile));
            return;
        }
        FishEyeClassLoader fcl = FishEyeCtl.CLASSLOADER;
        if (fcl == null) {
            Logs.APP_LOG.error((Object)"Internal FishEye problem: could not load svn jar because we couldn't find our classloader.");
            return;
        }
        try {
            fcl.addJar(jarfile);
            Logs.APP_LOG.info((Object)("Loaded svn jar from " + jarfile));
        }
        catch (MalformedURLException e2) {
            Logs.APP_LOG.error((Object)"problem loading jar", (Throwable)e2);
        }
    }
}

