/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.ContextDefinition;
import com.cenqua.fisheye.syntax.ContextReference;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionGenerator;
import com.cenqua.fisheye.syntax.RegionList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MatchAction {
    private List contextRefs = new ArrayList();
    private List regionGenerators = new ArrayList();
    public static final MatchAction EXIT_CONTEXT_ACTION = new MatchAction(){

        public boolean perform(InputState input, Map matchRegions, RegionList outputRegions) {
            return false;
        }
    };
    public static final MatchAction NOOP_ACTION = new MatchAction(){

        public boolean perform(InputState input, Map matchRegions, RegionList outputRegions) {
            return true;
        }
    };

    public boolean perform(InputState input, Map matchRegions, RegionList outputRegions) {
        if (this.contextRefs.size() > 0) {
            for (ContextReference cr : this.contextRefs) {
                if (cr.getSubmatchRef() != null) {
                    Region submatchRegion = (Region)matchRegions.get(cr.getSubmatchRef());
                    if (submatchRegion == null) continue;
                    RegionList subRegions = new RegionList();
                    InputState subInput = input.getSubInputState(submatchRegion);
                    cr.getContextDefinition().generateRegions(subInput, subRegions);
                    subRegions.translate(submatchRegion.getStart());
                    outputRegions.addAll(subRegions);
                    continue;
                }
                cr.getContextDefinition().generateRegions(input, outputRegions);
            }
            Region start = (Region)matchRegions.get("0");
            int allStart = start.getStart();
            int allEnd = input.getOffset();
            matchRegions.put("ALL", new Region(allStart, allEnd));
        }
        for (RegionGenerator region : this.regionGenerators) {
            region.generate(input, matchRegions, outputRegions);
        }
        return true;
    }

    public void addContextRef(ContextReference contextRef) {
        this.contextRefs.add(contextRef);
    }

    public void resolveContextRefs(ContextDefinition parent) {
        for (ContextReference contextRef : this.contextRefs) {
            ContextDefinition cd = parent.getContextDef(contextRef);
            if (cd == null) {
                throw new RuntimeException(contextRef.getLine() + ":" + contextRef.getColumn() + ": unknown context '" + contextRef.getName() + "'");
            }
            contextRef.setContextDefinition(cd);
        }
    }

    public void addRegionGenerator(RegionGenerator re) {
        this.regionGenerators.add(re);
    }

    public String toString() {
        String res = "MatchAction{contextRefs={";
        String sep = "";
        Iterator it = this.contextRefs.iterator();
        while (it.hasNext()) {
            res = res + sep + it.next();
            sep = ",";
        }
        res = res + "};regionGenerators={";
        sep = "";
        it = this.regionGenerators.iterator();
        while (it.hasNext()) {
            res = res + sep + it.next();
            sep = ",";
        }
        res = res + "}}";
        return res;
    }
}

