/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.crowd;

import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.BaseAuth;

public class CrowdAuthTok
extends BaseAuth.AuthTok {
    SOAPPrincipal principal;
    String initialToken;
    String displayName;
    String email;

    public CrowdAuthTok(SOAPPrincipal principal, String initialToken) {
        this.principal = principal;
        this.initialToken = initialToken;
        this.processAll();
    }

    public String getEmail() {
        return this.email;
    }

    public String getUsername() {
        return this.principal.getName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getAuthType() {
        return 6;
    }

    private void processAll() {
        try {
            this.processEmail();
            this.processFullName();
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    protected void processFullName() {
        String[] fn = this.getPropertyValues("givenName");
        String[] ln = this.getPropertyValues("sn");
        StringBuffer fullName = new StringBuffer();
        if (fn.length > 0) {
            fullName.append(fn[0]);
        }
        if (ln.length > 0) {
            if (fullName.length() > 0) {
                fullName.append(" ");
            }
            fullName.append(ln[0]);
        }
        this.displayName = fullName.toString();
    }

    protected void processEmail() {
        String[] email = this.getPropertyValues("mail");
        this.email = email.length > 0 ? email[0] : "";
    }

    protected String[] getPropertyValues(String key) {
        if (this.principal != null) {
            SOAPAttribute[] attributes = this.principal.getAttributes();
            for (int i2 = 0; i2 < attributes.length; ++i2) {
                if (!attributes[i2].getName().equals(key)) continue;
                return attributes[i2].getValues();
            }
        }
        return new String[0];
    }
}

