/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.FileNameMap;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class CustomFileNameMap
implements FileNameMap {
    private final Map mMapping = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomFileNameMap(File file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                this.parseLine(line);
            }
        }
        finally {
            in.close();
        }
    }

    private void parseLine(String line) {
        String mimetype;
        StringTokenizer tok = new StringTokenizer(line);
        if (tok.hasMoreTokens()) {
            mimetype = tok.nextToken();
        } else {
            Logs.APP_LOG.warn((Object)("not a valid line in mime type file:" + line));
            return;
        }
        while (tok.hasMoreTokens()) {
            String ext = tok.nextToken();
            this.mMapping.put(ext, mimetype);
        }
    }

    public String getContentTypeFor(String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (idx == -1) {
            idx = 0;
        }
        String ext = fileName.substring(idx + 1);
        String type = (String)this.mMapping.get(ext);
        return type;
    }
}

