/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.StringCharacterIterator;

public class Interval
implements Serializable {
    private static final BigDecimal POINT_FIVE = new BigDecimal(0.5);
    public static final int UNIT_SECOND = 0;
    public static final int UNIT_MINUTE = 1;
    public static final int UNIT_HOUR = 2;
    public static final int UNIT_DAY = 3;
    public static final int UNIT_WEEK = 4;
    public static final int UNIT_MONTH = 5;
    public static final int UNIT_YEAR = 6;
    public static final Interval ZERO_SECONDS = new Interval(0L, 0);
    private static final int[] UNITS = new int[]{0, 1, 2, 3, 4, 5, 6};
    public static final Interval ZERO_INTERVAL = new Interval(0L, 3);
    private static final BigDecimal[] MULTIPLIERS = new BigDecimal[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L), BigDecimal.valueOf(24L), BigDecimal.valueOf(7L), new BigDecimal(4.348), BigDecimal.valueOf(12L)};
    private static final String[] NAMES = new String[]{"second", "minute", "hour", "day", "week", "month", "year"};
    private static final String[] ABBREV_NAMES = new String[]{"s", "mi", "h", "d", "w", "mo", "y"};
    private BigDecimal magnitude = null;
    private int unit = 3;

    public Interval(BigDecimal magnitude, int unit) {
        this.magnitude = magnitude;
        this.unit = unit;
    }

    public Interval(long magnitude, int unit) {
        this(BigDecimal.valueOf(magnitude), unit);
    }

    public Interval(double magnitude, int unit) {
        this(new BigDecimal(magnitude), unit);
    }

    public Interval(String timeDescription, int defaultUnit) {
        this.unit = defaultUnit;
        this.initialise(timeDescription);
    }

    public Interval(String timeDescription) {
        this.initialise(timeDescription);
    }

    private void initialise(String timeDescription) {
        String amountString;
        int unitIndex = -1;
        boolean digitSeen = false;
        StringCharacterIterator sci = new StringCharacterIterator(timeDescription.toLowerCase());
        char c2 = sci.first();
        while (c2 != '\uffff') {
            if (Character.isDigit(c2)) {
                digitSeen = true;
            } else if (!Character.isWhitespace(c2) && c2 != '.' && (c2 != '-' || digitSeen)) {
                switch (c2) {
                    case 's': {
                        this.unit = 0;
                        break;
                    }
                    case 'm': {
                        this.unit = 1;
                        int index = sci.getIndex() + 1;
                        if (index == timeDescription.length() || timeDescription.charAt(index) != 'o') break;
                        this.unit = 5;
                        break;
                    }
                    case 'h': {
                        this.unit = 2;
                        break;
                    }
                    case 'd': {
                        this.unit = 3;
                        break;
                    }
                    case 'w': {
                        this.unit = 4;
                        break;
                    }
                    case 'y': {
                        this.unit = 6;
                    }
                }
                unitIndex = sci.getIndex();
                break;
            }
            c2 = sci.next();
        }
        String string = amountString = unitIndex == -1 ? timeDescription.trim() : timeDescription.substring(0, unitIndex).trim();
        if (amountString.length() == 0) {
            throw new NumberFormatException("Intervals must have a magnitude - not found in '" + timeDescription + "'");
        }
        this.magnitude = new BigDecimal(amountString.trim());
    }

    public BigDecimal getValueInUnits(int desiredUnit) {
        BigDecimal adjustedMagnitude;
        block3: {
            block2: {
                adjustedMagnitude = this.magnitude;
                if (desiredUnit >= this.unit) break block2;
                for (int i2 = this.unit; i2 != desiredUnit; --i2) {
                    adjustedMagnitude = adjustedMagnitude.multiply(MULTIPLIERS[i2]);
                }
                break block3;
            }
            if (desiredUnit <= this.unit) break block3;
            for (int i3 = desiredUnit; i3 != this.unit; --i3) {
                adjustedMagnitude = adjustedMagnitude.divide(MULTIPLIERS[i3], 2, 4);
            }
        }
        return adjustedMagnitude;
    }

    public long getValueInMillis() {
        BigDecimal secs = this.getValueInUnits(0);
        return secs.longValue() * 1000L;
    }

    public String toString(int desiredUnit, boolean abbreviate) {
        String sep;
        BigDecimal adjustedMag = this.getValueInUnits(desiredUnit);
        String unitName = abbreviate ? ABBREV_NAMES[desiredUnit] : NAMES[desiredUnit];
        String string = sep = abbreviate ? "" : " ";
        String suffix = abbreviate ? "" : (adjustedMag.compareTo(BigDecimal.valueOf(1L)) == 0 ? "" : "s");
        String description = adjustedMag.toString() + sep + unitName + suffix;
        return description;
    }

    public String toIntString(int desiredUnit) {
        BigDecimal adjustedMag = this.getValueInUnits(desiredUnit);
        String unitName = NAMES[desiredUnit];
        String description = adjustedMag.longValue() + " " + unitName + (adjustedMag.compareTo(BigDecimal.valueOf(1L)) == 0 ? "" : "s");
        return description;
    }

    public String toString() {
        return this.toString(this.unit, false);
    }

    public String toString(boolean abbreviate) {
        return this.toString(this.unit, abbreviate);
    }

    public String toSensibleString() {
        for (int i2 = UNITS.length - 1; i2 >= 0; --i2) {
            BigDecimal val = this.getValueInUnits(UNITS[i2]);
            if ((val = val.setScale(0, 4)).longValue() < 1L) continue;
            String description = val.longValue() + " " + NAMES[i2] + (val.intValue() == 1 ? "" : "s");
            return description;
        }
        return this.toString();
    }

    public int getUnit() {
        return this.unit;
    }

    public BigDecimal getMagnitude() {
        return this.magnitude;
    }

    public int compareTo(Interval rhs) {
        int baseUnit = this.unit;
        if (baseUnit > rhs.unit) {
            baseUnit = rhs.unit;
        }
        BigDecimal rhsMagnitude = rhs.getValueInUnits(baseUnit);
        BigDecimal lhsMagnitude = this.getValueInUnits(baseUnit);
        return lhsMagnitude.compareTo(rhsMagnitude);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Interval)) {
            return false;
        }
        Interval rhsInterval = (Interval)rhs;
        return this.magnitude.equals(rhsInterval.magnitude) && this.unit == rhsInterval.unit;
    }

    public int hashCode() {
        return this.magnitude.hashCode() + this.unit;
    }

    public Interval subtract(Interval rhs) {
        BigDecimal rhsMagnitude;
        BigDecimal lhsMagnitude;
        Interval result;
        BigDecimal lhsUnitMagnitude;
        int bigUnit = rhs.unit;
        int smallUnit = this.unit;
        if (bigUnit < smallUnit) {
            bigUnit = this.unit;
            smallUnit = rhs.unit;
        }
        if ((lhsUnitMagnitude = (result = new Interval((lhsMagnitude = this.getValueInUnits(smallUnit)).subtract(rhsMagnitude = rhs.getValueInUnits(smallUnit)), smallUnit)).getValueInUnits(this.unit)).abs().compareTo(POINT_FIVE) >= 0) {
            result = new Interval(lhsUnitMagnitude, this.unit);
        }
        return result;
    }

    public Interval add(Interval rhs) {
        int bigUnit = rhs.unit;
        int smallUnit = this.unit;
        if (bigUnit < smallUnit) {
            bigUnit = this.unit;
            smallUnit = rhs.unit;
        }
        BigDecimal lhsMagnitude = this.getValueInUnits(smallUnit);
        BigDecimal rhsMagnitude = rhs.getValueInUnits(smallUnit);
        Interval result = new Interval(lhsMagnitude.add(rhsMagnitude), smallUnit);
        BigDecimal lhsUnitMagnitude = result.getValueInUnits(this.unit);
        result = new Interval(lhsUnitMagnitude, this.unit);
        return result;
    }

    public int signum() {
        return this.magnitude.signum();
    }
}

