/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.logging.Logs;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class LatchedRunnable
implements Runnable {
    private CountDownLatch latch = new CountDownLatch(1);
    private Thread runner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            this.runner = Thread.currentThread();
            this.doTask();
        }
        finally {
            this.latch.countDown();
        }
    }

    public boolean await(long millis) {
        try {
            return this.latch.await(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            Logs.APP_LOG.warn((Object)"Interrupted awaiting P4 Process output pump to complete");
            throw new RuntimeException("Interrupted waiting for P4 Process output pump", e2);
        }
    }

    public boolean isRunning() {
        return this.latch.getCount() > 0L;
    }

    protected abstract void doTask();

    public void interrupt() {
        if (this.runner != null) {
            this.runner.interrupt();
        }
    }
}

