/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.util.LineCounter;
import java.io.IOException;
import java.io.InputStream;

public class LineCountingInputStream
extends InputStream {
    private LineCounter counter = new LineCounter();
    private InputStream input;
    private CharMode charMode;
    private int firstByte;
    private boolean halfCharPresent;
    private boolean lastWasCR;

    public LineCountingInputStream(InputStream input, CharMode charMode) {
        this.input = input;
        this.charMode = charMode;
    }

    public LineCountingInputStream(InputStream input) {
        this(input, CharMode.BYTES);
    }

    public int read() throws IOException {
        int ch = this.input.read();
        this.processChar(ch);
        return ch;
    }

    private void processChar(int ch) throws IOException {
        if (this.charMode == CharMode.BYTES || this.lastWasCR && ch == 10) {
            this.lastWasCR = false;
            this.counter.process(ch);
        } else {
            this.lastWasCR = false;
            if (this.halfCharPresent) {
                this.halfCharPresent = false;
                if (this.charMode == CharMode.BOM) {
                    if (this.firstByte == -2 && ch == -1) {
                        this.charMode = CharMode.BIG_ENDIAN;
                    } else if (this.firstByte == -1 && ch == -2) {
                        this.charMode = CharMode.LITTLE_ENDIAN;
                    } else {
                        this.charMode = CharMode.LITTLE_ENDIAN;
                        int b2 = ch << 8 | this.firstByte;
                        this.counter.process(b2);
                    }
                } else {
                    int b3 = this.charMode == CharMode.LITTLE_ENDIAN ? ch << 8 | this.firstByte : this.firstByte << 8 | ch;
                    this.counter.process(b3);
                    if (b3 == 13) {
                        this.lastWasCR = true;
                    }
                }
            } else {
                this.halfCharPresent = true;
                this.firstByte = ch;
            }
        }
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int numRead = this.input.read(b2, off, len);
        for (int i2 = off; i2 < off + numRead; ++i2) {
            this.processChar(b2[i2]);
        }
        return numRead;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public int getLineCount() throws IOException {
        return this.counter.getLineCount();
    }

    public void readFully() throws IOException {
        byte[] buffer = new byte[8192];
        while (this.read(buffer) != -1) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharMode {
        BYTES,
        LITTLE_ENDIAN,
        BIG_ENDIAN,
        BOM;

    }
}

