/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SortedList {
    private final ArrayList list;
    private final Comparator comp;

    public SortedList(Comparator comp) {
        this(comp, 10);
    }

    public SortedList(Comparator comp, int minCapacity) {
        this.comp = comp;
        this.list = new ArrayList(minCapacity);
    }

    public int binarySearch(Object value) {
        return this.binarySearch(value, 0, this.list.size());
    }

    public int binarySearch(Object value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        int size = this.list.size();
        if (toIndex > size) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        if (fromIndex < size && this.comp.compare(value, this.list.get(fromIndex)) <= 0) {
            return fromIndex;
        }
        if (toIndex < size && this.comp.compare(value, this.list.get(toIndex)) >= 0) {
            return toIndex;
        }
        int low = 0;
        int high = size - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = this.list.get(mid);
            int cmp = this.comp.compare(midVal, value);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        int ip = low;
        return ip;
    }

    public void addAll(Collection c2) {
        this.list.ensureCapacity(this.list.size() + c2.size());
        for (Object o : c2) {
            this.add(o);
        }
    }

    public void addAll(SortedList sl) {
        this.addAll(sl.list);
    }

    public int add(Object value) {
        int idx = this.binarySearch(value);
        assert (idx >= 0);
        assert (idx <= this.list.size());
        if (idx == this.list.size()) {
            this.list.add(value);
        } else {
            this.list.add(idx, value);
        }
        return idx;
    }

    public void addLast(Object value) {
        if (this.size() > 0 && this.comp.compare(this.getLast(), value) > 0) {
            throw new IllegalArgumentException(this.getLast() + " > " + value);
        }
        this.list.add(value);
    }

    public Object getLast() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }

    public Object get(int i2) {
        return this.list.get(i2);
    }

    public String toString() {
        return this.list.toString();
    }

    public int size() {
        return this.list.size();
    }

    public void clear() {
        this.list.clear();
    }

    public Object remove(int i2) {
        return this.list.remove(i2);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public Iterator iterator(int i2) {
        return this.list.subList(i2, this.list.size()).iterator();
    }

    public List asList() {
        return new ArrayList(this.list);
    }

    public void truncateSize(int maxHits) {
        if (this.list.size() == maxHits + 1) {
            this.list.remove(maxHits);
        }
        if (this.list.size() > maxHits) {
            this.list.subList(maxHits, this.list.size()).clear();
        }
    }
}

