/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

public class Throttle {
    private long millisPerOperation = 0L;
    private long lastOperation = 0L;

    public synchronized void setOperationsPerSecond(float opsPerSecond) {
        this.millisPerOperation = (long)(1000.0 / (double)opsPerSecond);
    }

    public synchronized void apply() {
        if (this.millisPerOperation != 0L) {
            long now = System.currentTimeMillis();
            while (now - this.lastOperation < this.millisPerOperation) {
                try {
                    long delay = this.lastOperation + this.millisPerOperation - now + 1L;
                    if (delay > 0L) {
                        Thread.sleep(delay);
                    }
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException e2) {}
            }
            this.lastOperation = now;
        }
    }
}

