/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.diff;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.util.diff.SectionSpec;

public abstract class HunkFactory {
    private int currentFromLine;
    private int currentToLine;
    private int hunkFrom = -1;
    private int hunkFromLength;
    private int hunkTo;
    private int hunkToLength;
    private SectionSpec section;
    private int sectionAdded;
    private int sectionRemoved;

    public void startSection(SectionSpec section) {
        this.section = section;
        this.hunkFrom = -1;
        this.currentFromLine = section.getFrom();
        this.currentToLine = section.getTo();
        this.sectionAdded = 0;
        this.sectionRemoved = 0;
    }

    public void endSection() {
        this.addCurrentHunk();
    }

    public void addLine() {
        if (this.hunkFrom == -1) {
            this.newHunk();
        }
        ++this.hunkToLength;
        ++this.currentToLine;
        ++this.sectionAdded;
    }

    public void removeLine() {
        if (this.hunkFrom == -1) {
            this.newHunk();
        }
        ++this.hunkFromLength;
        ++this.currentFromLine;
        ++this.sectionRemoved;
    }

    private void newHunk() {
        this.hunkFrom = this.currentFromLine;
        this.hunkFromLength = 0;
        this.hunkTo = this.currentToLine;
        this.hunkToLength = 0;
    }

    public void contextLine() {
        this.addCurrentHunk();
        ++this.currentFromLine;
        ++this.currentToLine;
    }

    private void addCurrentHunk() {
        if (this.hunkFrom != -1) {
            if (this.hunkFromLength == 0 && this.hunkFrom != 0) {
                --this.hunkFrom;
            }
            if (this.hunkToLength == 0 && this.hunkTo != 0) {
                --this.hunkTo;
            }
            Hunk hunk = new Hunk(this.hunkFrom, this.hunkTo, this.hunkFromLength, this.hunkToLength);
            this.addHunk(hunk);
            this.hunkFrom = -1;
        }
    }

    public abstract void addHunk(Hunk var1);
}

