/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.CustomContent;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.AuthorPageAction;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.ChangelogServlet;
import com.cenqua.fisheye.web.ChartPageAction;
import com.cenqua.fisheye.web.ConfigRssAction;
import com.cenqua.fisheye.web.ConfigWatchAction;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.LoginServlet;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.QuickSearchAction;
import com.cenqua.fisheye.web.SearchRepositoryServlet;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.ViewRepositoryServlet;
import com.cenqua.fisheye.web.rdiff.RDiffAction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ActionDispatcherServlet
extends HttpServlet {
    private static final Map<String, Class> ACTION_MAP = new HashMap<String, Class>();
    public static final String STATIC_DIR = "static/k4ui8v";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext ctx = config.getServletContext();
        ctx.setAttribute("CUSTOM_CONTENT", (Object)new CustomContent());
        ctx.setAttribute("FISHEYE_VERSION_INFO", (Object)new FisheyeVersionInfo());
        ctx.setAttribute("STATICDIR", (Object)STATIC_DIR);
        ctx.setAttribute("isCrucible", (Object)AppConfig.isCrucible());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            this.doIt(req, resp);
        }
        catch (ServletException e2) {
            Throwable rc = e2.getRootCause();
            while (rc != null) {
                Logs.APP_LOG.info((Object)"Servlet Exception, rootcause=", rc);
                if (rc instanceof ServletException) {
                    rc = ((ServletException)rc).getRootCause();
                    continue;
                }
                rc = null;
            }
            throw e2;
        }
    }

    protected void doIt(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("FETOUR") != null) {
            req.getSession(true).setAttribute("FETOUR", (Object)req.getParameter("FETOUR"));
        }
        RootConfig rootConfig = AppConfig.getsConfig();
        Disposer.pushThreadInstance();
        try {
            UserLogin user;
            Class actionClass;
            String actionName = req.getServletPath();
            if (actionName.startsWith("/")) {
                actionName = actionName.substring(1);
            }
            if ((actionClass = ACTION_MAP.get(actionName)) == null) {
                Logs.APP_LOG.info((Object)("unknown action " + actionName + " referer=" + req.getHeader("Referer")));
                ServletUtils.send404(req, resp, "unknown action " + actionName);
                return;
            }
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)("mapped action " + actionName + " to " + actionClass + " pi = " + req.getPathInfo()));
            }
            FishEyePathInfo piHelper = this.parsePathInfo(req);
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)("pi: " + piHelper.getRepname() + " " + piHelper.getLocalPath() + " " + piHelper.getCommandString()));
            }
            if (piHelper.isEmpty()) {
                resp.sendRedirect(req.getContextPath() + "/");
                return;
            }
            String repname = piHelper.getRepname();
            RepositoryHandle h2 = AppConfig.getsConfig().getRepositoryManager().getRepository(repname);
            if (h2 == null) {
                ServletUtils.send404(req, resp, "no such repository - " + repname);
                return;
            }
            UserManager um = rootConfig.getUserManager();
            if (!um.hasPermissionToAccess(user = um.getCurrentUser(req), h2)) {
                if (user == null) {
                    LoginServlet.redirectToLogin(req, resp);
                } else {
                    resp.sendError(403, "permission denied");
                }
                return;
            }
            if (!h2.getCfg().isEnabled()) {
                throw new ServletException("Repository has been disabled (by administrator).");
            }
            if (!h2.isRunning()) {
                throw new ServletException("Repository is not running (it is " + h2.getStateDescription() + "). Please try again later. Current status is \"" + h2.getStatus().getMessage() + "\"");
            }
            piHelper.initEngine(h2);
            try {
            }
            catch (Exception e2) {
                throw new ServletException("error with action " + actionName);
            }
            CookiePreferences up = PreferenceManager.getPreferences(req);
            RepositoryConfig rcfg = piHelper.getRepository();
            req.setAttribute("RepositoryConfig", (Object)rcfg);
            req.setAttribute("RepositoryEngine", (Object)piHelper.getEngine());
            req.setAttribute("repname", (Object)rcfg.getName());
            req.setAttribute("reptype", (Object)piHelper.getEngine().getRevisionCache().getRepositoryType());
            req.setAttribute("slurpStatus", (Object)piHelper.getEngine().getStatus());
            for (BaseAction action = (BaseAction)actionClass.newInstance(); action != null; action = action.processRequest()) {
                long ifModSince;
                long lastMod;
                boolean skipLastMod;
                action.setupInternal(piHelper, req, resp, this.getServletContext());
                action.setup();
                boolean bl = skipLastMod = !ActionDispatcherServlet.isHeadOrGet(req) || this.inTourMode(req);
                if (skipLastMod || (lastMod = action.computeLastModified()) == -1L) continue;
                lastMod = Math.max(lastMod, AppConfig.getLastModified());
                if (up.getLastModified() != null) {
                    lastMod = Math.max(lastMod, up.getLastModified());
                }
                if ((ifModSince = req.getDateHeader("If-Modified-Since")) != -1L && ifModSince >= lastMod / 1000L * 1000L) {
                    resp.setStatus(304);
                    return;
                }
                resp.setDateHeader("Last-Modified", lastMod);
            }
        }
        catch (DbException e3) {
            Logs.APP_LOG.warn((Object)"problem during request", (Throwable)e3);
            throw new ServletException((Throwable)e3);
        }
        catch (RCSParser.ParseException e4) {
            Logs.APP_LOG.warn((Object)"problem during request", (Throwable)e4);
            throw new ServletException((Throwable)e4);
        }
        catch (RepositoryHandle.StateException e5) {
            Logs.APP_LOG.warn((Object)"problem during request", (Throwable)e5);
            throw new ServletException((Throwable)e5);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private FishEyePathInfo parsePathInfo(HttpServletRequest req) throws ServletException {
        FishEyePathInfo pi = new FishEyePathInfo(req);
        if (pi.getFullPath().isAbove()) {
            throw new ServletException("Relative path specified " + pi.getFullPath());
        }
        return pi;
    }

    private boolean inTourMode(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session == null) {
            return false;
        }
        Object fegState = session.getAttribute("FETOUR");
        return fegState != null;
    }

    private static boolean isHeadOrGet(HttpServletRequest req) {
        return req.getMethod().equals("GET") || req.getMethod().equals("HEAD");
    }

    static {
        ACTION_MAP.put("viewrep", ViewRepositoryServlet.class);
        ACTION_MAP.put("browse", ViewRepositoryServlet.class);
        ACTION_MAP.put("search", SearchRepositoryServlet.class);
        ACTION_MAP.put("changelog", ChangelogServlet.class);
        ACTION_MAP.put("qsearch", QuickSearchAction.class);
        ACTION_MAP.put("rsscfg", ConfigRssAction.class);
        ACTION_MAP.put("watchcfg", ConfigWatchAction.class);
        ACTION_MAP.put("rdiff", RDiffAction.class);
        ACTION_MAP.put("author", AuthorPageAction.class);
        ACTION_MAP.put("chart", ChartPageAction.class);
    }
}

