/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LineCountChartLine;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.web.BaseAction;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartUtilities;

public class AuthorPageAction
extends BaseAction {
    private RepositoryEngine engine;
    int numRecentChangeSets = 10;

    public int getNumRecentChangeSets() {
        return this.numRecentChangeSets;
    }

    public void setNumRecentChangeSets(int numRecentChangeSets) {
        this.numRecentChangeSets = numRecentChangeSets;
    }

    public void setup() {
        this.engine = this.getPathInfo().getEngine();
    }

    public BaseAction handleRequest() throws ServletException, IOException, DbException, RCSParser.ParseException {
        Path localPath = this.getPathInfo().getLocalPath();
        HttpServletResponse resp = this.getResponse();
        HttpServletRequest req = this.getRequest();
        String author = this.extractAuthorName(localPath);
        LineCountChartLine charter = new LineCountChartLine();
        if (req.getParameterMap().containsKey("authorHistoryChart")) {
            resp.setContentType(LineCountChartUtils.getImageContentType());
            Logs.APP_LOG.warn((Object)"AuthorPageAction handleRequest: - params all blank");
            String br = this.getPathInfo().getEngine().getRevisionCache().getFileHistory(new Path("")).getMainBranch();
            BucketGraph bucketGraph = this.getPathInfo().getEngine().getBucketGraph();
            CalculatedBucketGraphXY graphs = bucketGraph.getXYSeries(new ParameterSetRetrieve(new Path(""), br, bucketGraph.isCaseSensitive()), 300);
            BufferedImage image = charter.renderPathHistoryImage(graphs, 300, 220, null, LineCountChart.getGraphTimeZone(this.getRequest()), true);
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)resp.getOutputStream(), (BufferedImage)image);
        } else {
            req.setAttribute("author", (Object)author);
            req.setAttribute("fpath", (Object)this.getPathInfo().getFullPath());
            req.setAttribute("lpath", (Object)this.getPathInfo().getLocalPath());
            req.setAttribute("action", (Object)this);
            this.getRequest().getRequestDispatcher("/WEB-INF/jsp/author.jsp").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        }
        return null;
    }

    private String extractAuthorName(Path localPath) {
        String author = "".equals(localPath.toString()) ? null : localPath.toString();
        return author;
    }

    public List getRecentChangeSets() {
        try {
            RecentChangesParams params = new RecentChangesParams();
            params.setMaxReturn(this.numRecentChangeSets);
            String author = this.extractAuthorName(this.getPathInfo().getLocalPath());
            if (author != null) {
                AndQuery3 and = new AndQuery3();
                and.addClause(new TermQuery3(CommonSchema.E_AUTHOR_TO_REVID, author.toLowerCase(Locale.US), null));
                params.setConstraint(and);
            }
            return this.getRepositoryCache().findRecentChangeSets(params);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"could not compute recent changed", (Throwable)e2);
            return null;
        }
    }
}

