/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DirInfo;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.fisheye.web.WaybackSpec;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelogExplorer {
    private final MinMaxLongRange mDirDateRange;
    private final MinMaxLongRange mPageDateRange = new MinMaxLongRange();
    private final RevisionCache mCrep;
    private final WaybackSpec mWB;
    private final Path mLPath;
    private List mChangeSets;
    private long mSelectedDate;
    private String mFromChangeSetId = null;
    private boolean fromChangeSetIdInc = false;
    private String mToChangeSetId = null;
    private boolean toChangeSetIdInc = false;
    private String mShowChangeSetId = null;
    private Long mToDate = null;
    private String nextInPast;
    private boolean nextInPastIsInc = false;
    private String nextInFuture;
    private boolean nextInFutureIsInc = false;
    private final TimeZone mTimeZone;

    public ChangelogExplorer(Path lpath, RevisionCache crep, WaybackSpec wb) throws DbException {
        this.mCrep = crep;
        this.mLPath = lpath;
        this.mWB = wb;
        this.mTimeZone = AppConfig.getsConfig().getTimezone();
        DirInfo dirInfo = this.mCrep.findDirInfo(lpath);
        if (dirInfo == null) {
            this.mDirDateRange = new MinMaxLongRange();
            this.mDirDateRange.add(System.currentTimeMillis());
        } else {
            this.mDirDateRange = dirInfo.getSubTreeDateRange();
        }
    }

    public Date getStartDateValue() {
        return new Date(this.getStartDate());
    }

    public long getStartDate() {
        return this.mDirDateRange.getMin();
    }

    public Date getEndDateValue() {
        return new Date(this.getEndDate());
    }

    public long getEndDate() {
        return this.mDirDateRange.getMax();
    }

    public Date getThisPageStartDateValue() {
        return new Date(this.getThisPageStartDate());
    }

    public long getThisPageStartDate() {
        if (this.mPageDateRange.isSet()) {
            return this.mPageDateRange.getMin();
        }
        return this.getStartDate();
    }

    public Date getThisPageEndDateValue() {
        return new Date(this.getThisPageEndDate());
    }

    public long getThisPageEndDate() {
        if (this.mPageDateRange.isSet()) {
            return this.mPageDateRange.getMax();
        }
        return this.getEndDate();
    }

    public List<YearCalendar> getYears() {
        GregorianCalendar cal = DateHelper.timeAsCalendar(this.getStartDate(), this.mTimeZone);
        ChangelogExplorer.truncateToStartOfYear(cal);
        ArrayList<YearCalendar> years = new ArrayList<YearCalendar>();
        while (cal.getTimeInMillis() < this.getEndDate()) {
            GregorianCalendar start = (GregorianCalendar)cal.clone();
            YearCalendar year = new YearCalendar(start);
            years.add(year);
            cal.add(1, 1);
        }
        return years;
    }

    public List getChangesets() {
        return this.mChangeSets;
    }

    public YearCalendar getSelectedYear() {
        GregorianCalendar cal = DateHelper.timeAsCalendar(this.mSelectedDate, this.mTimeZone);
        ChangelogExplorer.truncateToStartOfYear(cal);
        return new YearCalendar(cal);
    }

    public ChangeSet getOldestChangeSet() {
        if (this.mChangeSets.isEmpty()) {
            return null;
        }
        return (ChangeSet)this.mChangeSets.get(this.mChangeSets.size() - 1);
    }

    public ChangeSet getYoungestChangeSet() {
        if (this.mChangeSets.isEmpty()) {
            return null;
        }
        return (ChangeSet)this.mChangeSets.get(0);
    }

    public String getNextInPast() {
        return this.nextInPast;
    }

    public String getNextInFuture() {
        return this.nextInFuture;
    }

    public boolean isNextInFutureIsInc() {
        return this.nextInFutureIsInc;
    }

    public boolean isNextInPastIsInc() {
        return this.nextInPastIsInc;
    }

    public void computeData(int perPage) throws DbException {
        this.mSelectedDate = System.currentTimeMillis();
        RecentChangesParams params = new RecentChangesParams();
        params.setPath(this.mLPath);
        params.setMaxReturn(perPage);
        params.setMinDate(this.getStartDate());
        params.setMaxDate(this.getEndDate());
        if (this.mWB != null) {
            params.setConstraint(this.mWB.getConstraintQuery3(false));
        }
        this.setupParams(params);
        this.mChangeSets = this.mCrep.findRecentChangeSets(params);
        if (this.mChangeSets.isEmpty()) {
            this.nextInFuture = this.mToChangeSetId;
            this.nextInFutureIsInc = true;
            this.nextInPast = this.mFromChangeSetId;
            this.nextInPastIsInc = true;
        } else {
            ChangeSet csYoungest = (ChangeSet)this.mChangeSets.get(0);
            this.mSelectedDate = csYoungest.getDate();
            this.mPageDateRange.add(csYoungest.getDate());
            ChangeSet csOldest = (ChangeSet)this.mChangeSets.get(this.mChangeSets.size() - 1);
            this.mPageDateRange.add(csOldest.getDate());
            if (this.getEndDate() > this.getThisPageEndDate()) {
                this.nextInFuture = csYoungest.getId();
            }
            if (this.getStartDate() < this.getThisPageStartDate()) {
                this.nextInPast = csOldest.getId();
            }
        }
    }

    private void setupParams(RecentChangesParams params) throws DbException {
        ChangeSet showChangeSet;
        if (this.mFromChangeSetId != null) {
            ChangeSet fromChangeSet = this.mCrep.getChangeSet(this.mFromChangeSetId);
            if (fromChangeSet != null) {
                params.setMinDate(fromChangeSet.getDate());
                params.setMaxDate(this.getEndDate());
                params.setSearchDirection(1);
                params.setMinChangeset(fromChangeSet, this.fromChangeSetIdInc);
            }
        } else if (this.mToChangeSetId != null) {
            ChangeSet toChangeSet = this.mCrep.getChangeSet(this.mToChangeSetId);
            if (toChangeSet != null) {
                params.setMinDate(this.getStartDate());
                params.setMaxDate(toChangeSet.getDate());
                params.setSearchDirection(0);
                params.setMaxChangeset(toChangeSet, this.toChangeSetIdInc);
            }
        } else if (this.mShowChangeSetId != null && (showChangeSet = this.mCrep.getChangeSet(this.mShowChangeSetId)) != null) {
            params.setMinDate(this.getStartDate());
            params.setMaxDate(showChangeSet.getDate());
            params.setSearchDirection(0);
            params.setMaxChangeset(showChangeSet, true);
        }
        if (this.mToDate != null) {
            params.setMaxDate(this.mToDate);
        }
    }

    private static void truncateToStartOfYear(GregorianCalendar cal) {
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private static void truncateToStartOfMonth(GregorianCalendar cal) {
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    private static GregorianCalendar incrementAsNew(GregorianCalendar date, int field, int amount) {
        GregorianCalendar cal = (GregorianCalendar)date.clone();
        cal.add(field, amount);
        return cal;
    }

    private static boolean rangesOverlap(long start, long end, long d1, long d2) {
        return start <= d1 && d1 < end || start <= d2 && d2 < end || d1 <= start && start <= d2 || d1 <= end && end <= d2;
    }

    public void setFromChangeSetId(String fromChangeSetId) {
        this.mFromChangeSetId = fromChangeSetId;
    }

    public void setFromChangeSetIdInc(boolean fromChangeSetIdInc) {
        this.fromChangeSetIdInc = fromChangeSetIdInc;
    }

    public void setToChangeSetId(String toChangeSetId) {
        this.mToChangeSetId = toChangeSetId;
    }

    public void setToChangeSetIdInc(boolean toChangeSetIdInc) {
        this.toChangeSetIdInc = toChangeSetIdInc;
    }

    public void setShowChangeSetId(String showChangeSetId) {
        this.mShowChangeSetId = showChangeSetId;
    }

    public void setToDate(long toDate) {
        this.mToDate = toDate;
    }

    public static List pertinantRevInfosInChangeset(ChangeSet cs, int max, Path relTo, boolean caseSensitive) throws DbException {
        if (cs == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<FileRevision> result = new ArrayList<FileRevision>();
        Iterator<RevInfoKey> keys = cs.getRevisionInfoKeys();
        int i2 = 0;
        while (keys.hasNext() && (max < 0 || result.size() < max)) {
            RevInfoKey key = keys.next();
            if (relTo == null || key.getPath().hasPrefix(relTo, caseSensitive)) {
                FileRevision info = cs.getRevisionInfo(i2);
                result.add(info);
            }
            ++i2;
        }
        return result;
    }

    public class DayCalendar
    extends BaseCalendar {
        public DayCalendar(GregorianCalendar firstDate) {
            super(firstDate, ChangelogExplorer.incrementAsNew(firstDate, 5, 1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MonthCalendar
    extends BaseCalendar {
        public MonthCalendar(GregorianCalendar firstDate) {
            super(firstDate, ChangelogExplorer.incrementAsNew(firstDate, 2, 1));
        }

        public List<List<DayCalendar>> getWeeksOfMonthMatrix() {
            TIntArrayList DAY_ORDER = new TIntArrayList();
            DAY_ORDER.add(1);
            DAY_ORDER.add(2);
            DAY_ORDER.add(3);
            DAY_ORDER.add(4);
            DAY_ORDER.add(5);
            DAY_ORDER.add(6);
            DAY_ORDER.add(7);
            int DAYS_IN_WEEK = DAY_ORDER.size();
            int LAST_DAY_OF_WEEK = DAY_ORDER.get(DAYS_IN_WEEK - 1);
            List<DayCalendar> days = this.getDaysOfMonth();
            ArrayList<List<DayCalendar>> matrix = new ArrayList<List<DayCalendar>>(6);
            ArrayList<DayCalendar> currentWeek = null;
            for (DayCalendar day : days) {
                if (currentWeek == null) {
                    currentWeek = new ArrayList<DayCalendar>(DAYS_IN_WEEK);
                    for (int j = 0; j < DAYS_IN_WEEK; ++j) {
                        currentWeek.add(null);
                    }
                }
                int dayOfWeek = day.getCalendar().get(7);
                int idx = DAY_ORDER.indexOf(dayOfWeek);
                currentWeek.set(idx, day);
                if (dayOfWeek != LAST_DAY_OF_WEEK) continue;
                matrix.add(currentWeek);
                currentWeek = null;
            }
            if (currentWeek != null) {
                matrix.add(currentWeek);
            }
            return matrix;
        }

        public List<DayCalendar> getDaysOfMonth() {
            ArrayList<DayCalendar> days = new ArrayList<DayCalendar>(31);
            GregorianCalendar cal = (GregorianCalendar)this.mFirstDate.clone();
            long endDate = this.mLastDate.getTimeInMillis();
            while (cal.getTimeInMillis() < endDate) {
                GregorianCalendar start = (GregorianCalendar)cal.clone();
                DayCalendar day = new DayCalendar(start);
                days.add(day);
                cal.add(5, 1);
            }
            return days;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class YearCalendar
    extends BaseCalendar {
        public YearCalendar(GregorianCalendar firstDate) {
            super(firstDate, ChangelogExplorer.incrementAsNew(firstDate, 1, 1));
        }

        public int getYear() {
            return this.mFirstDate.get(1);
        }

        public List<MonthCalendar> getMonths() {
            ArrayList<MonthCalendar> months = new ArrayList<MonthCalendar>(12);
            for (int i2 = 0; i2 <= 11; ++i2) {
                GregorianCalendar start = (GregorianCalendar)this.mFirstDate.clone();
                start.set(2, i2);
                MonthCalendar month = new MonthCalendar(start);
                months.add(month);
            }
            return months;
        }

        public MonthCalendar getSelectedMonth() {
            GregorianCalendar cal = DateHelper.timeAsCalendar(ChangelogExplorer.this.mSelectedDate, ChangelogExplorer.this.mTimeZone);
            ChangelogExplorer.truncateToStartOfMonth(cal);
            return new MonthCalendar(cal);
        }
    }

    public class BaseCalendar {
        protected final GregorianCalendar mFirstDate;
        protected final GregorianCalendar mLastDate;

        public BaseCalendar(GregorianCalendar firstDate, GregorianCalendar lastDate) {
            this.mFirstDate = firstDate;
            this.mLastDate = lastDate;
        }

        public Date getDate() {
            return this.mFirstDate.getTime();
        }

        public GregorianCalendar getCalendar() {
            return this.mFirstDate;
        }

        public long getStartTime() {
            return this.mFirstDate.getTimeInMillis();
        }

        public long getEndTime() {
            return this.mLastDate.getTimeInMillis();
        }

        public boolean isOnThisPage() {
            long d1 = this.mFirstDate.getTimeInMillis();
            long d2 = this.mLastDate.getTimeInMillis();
            long start = ChangelogExplorer.this.getThisPageStartDateValue().getTime();
            long end = ChangelogExplorer.this.getThisPageEndDateValue().getTime();
            return ChangelogExplorer.rangesOverlap(start, end, d1, d2);
        }

        public int getContainedRevisionCount() throws DbException {
            long d1 = this.mFirstDate.getTimeInMillis();
            long d2 = this.mLastDate.getTimeInMillis();
            AndQuery3 c2 = null;
            if (ChangelogExplorer.this.mWB != null) {
                c2 = ChangelogExplorer.this.mWB.getConstraintQuery3(false);
            }
            return ChangelogExplorer.this.mCrep.countRevisions(ChangelogExplorer.this.mLPath, d1, d2, c2);
        }
    }
}

