/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.view.DiffPrinter;
import com.cenqua.fisheye.diff.view.SectionView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class DiffExplorer {
    protected final HunkList mHunks;
    private int mContextLines = 3;
    protected final String mR1;
    protected final String mR2;
    private List sections;
    private DiffPrinter printer;
    private boolean sideBySide;
    private boolean softWrap;

    public DiffExplorer(String r2Desc, HunkList hunks, String r1Desc, boolean sideBySide, boolean softWrap) {
        this.softWrap = softWrap;
        this.sideBySide = sideBySide;
        this.mR2 = r2Desc;
        this.mHunks = hunks;
        this.mR1 = r1Desc;
    }

    public String getR1() {
        return this.mR1;
    }

    public String getR2() {
        return this.mR2;
    }

    public void setContextLines(int contextLines) {
        this.mContextLines = contextLines;
        this.sections = null;
    }

    public int getContextLines() {
        return this.mContextLines;
    }

    public boolean isAnySkippedSections() throws IOException {
        List l = this.getSections();
        for (Section section : l) {
            if (!section.isSkippedPrevious()) continue;
            return true;
        }
        return false;
    }

    public List getSections() throws IOException {
        if (this.sections == null) {
            this.sections = this.mHunks.getSections(this.mContextLines);
            this.printer = this.makePrinter(this.sections);
        }
        return this.sections;
    }

    public DiffPrinter getPrinter() throws IOException {
        this.getSections();
        this.printer.setAnySkippedSections(this.isAnySkippedSections());
        return this.printer;
    }

    private DiffPrinter makePrinter(List sections) {
        ArrayList<SectionView> views = new ArrayList<SectionView>(sections.size());
        for (Section s : sections) {
            views.add(this.makeSectionView(s));
        }
        return new DiffPrinter(views, this.sideBySide, this.softWrap);
    }

    protected abstract SectionView makeSectionView(Section var1);

    public boolean isIdentical() throws IOException {
        Iterator i2 = this.mHunks.getIterator();
        while (i2.hasNext()) {
            Hunk hunk = (Hunk)i2.next();
            if (hunk.isIgnored()) continue;
            return false;
        }
        return true;
    }
}

