/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.MultiMap;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FileHistoryExplorer {
    private final WaybackSpec mWB;
    private final MultiMap mBranchMap = new MultiMap();
    private int mWbSkippedCount = 0;
    private String mMainBranchName;

    public FileHistoryExplorer(FileHistory history, WaybackSpec wb) {
        this.mMainBranchName = history.getMainBranch();
        this.mWB = wb;
        for (String br : history.getBranches()) {
            List revs = history.getRevisions(br);
            Collections.reverse(revs);
            for (String rev : revs) {
                FileRevision info = history.getRevision(rev);
                if (this.mWB != null) {
                    if (this.mWB.matches(info, true)) {
                        this.mBranchMap.add(br, info);
                        continue;
                    }
                    ++this.mWbSkippedCount;
                    continue;
                }
                this.mBranchMap.add(br, info);
            }
        }
    }

    public int getWaybackSkippedCount() {
        return this.mWbSkippedCount;
    }

    public Map getInfoMap() {
        return this.mBranchMap.map();
    }

    public List getBranchRevisions() {
        ArrayList l = new ArrayList(this.mBranchMap.keySet());
        Collections.sort(l);
        int i2 = l.indexOf(this.mMainBranchName);
        if (i2 > 0) {
            l.add(0, l.remove(i2));
        }
        return l;
    }
}

