/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserAgentRewriteServlet
extends HttpServlet {
    File mWebroot;
    private static final String[][] sMappings = new String[][]{{"konqueror", "konqueror"}, {"firefox", "firefox"}, {"safari", "safari"}, {"omniweb", "omniweb"}, {"opera", "opera"}, {"webtv", "webtv"}, {"icab", "icab"}, {"msie", "msie"}, {"msie", "msie"}};

    public void init() throws ServletException {
        super.init();
        this.mWebroot = AppConfig.getWebAppLocation().getAbsoluteFile();
        Logs.APP_LOG.debug((Object)("webapp root is " + this.mWebroot));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pi = req.getPathInfo();
        if (pi == null) {
            resp.sendError(404);
            return;
        }
        if (pi.toLowerCase().startsWith("/web-inf")) {
            resp.sendError(401);
            return;
        }
        if (this.handleRemap(req, resp, pi + ".jsp")) {
            return;
        }
        req.getRequestDispatcher(pi).forward((ServletRequest)req, (ServletResponse)resp);
    }

    public boolean handleRemap(HttpServletRequest req, HttpServletResponse resp, String path) throws IOException, ServletException {
        File f2 = new File(this.mWebroot, path);
        if (f2.isFile()) {
            long lastMod = f2.lastModified();
            lastMod = Math.max(lastMod, AppConfig.getLastModified());
            long ifModSince = req.getDateHeader("If-Modified-Since");
            if (ifModSince != -1L && ifModSince >= lastMod / 1000L * 1000L) {
                if (Logs.APP_LOG.isDebugEnabled()) {
                    Logs.APP_LOG.debug((Object)("UAR: sent not-modified for " + path));
                }
                resp.setStatus(304);
                return true;
            }
            resp.setDateHeader("Last-Modified", lastMod);
            req.getRequestDispatcher(path).forward((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }

    public static String getUserAgentName(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent");
        if (ua == null) {
            return null;
        }
        ua = ua.toLowerCase();
        for (int i2 = 0; i2 < sMappings.length; ++i2) {
            String match = sMappings[i2][0];
            String value = sMappings[i2][1];
            if (!UserAgentRewriteServlet.checkIt(ua, match)) continue;
            return value;
        }
        if (!UserAgentRewriteServlet.checkIt(ua, "compatible")) {
            return "netscape";
        }
        return null;
    }

    private static boolean checkIt(String ua, String match) {
        return ua.indexOf(match) != -1;
    }
}

