/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.WaybackSpec;

public class Watch {
    private long id;
    private String user;
    private String rep;
    private Path path;
    private WaybackSpec constraint;
    private long lastChecked;
    private RevInfoKey lastRevisionSent = null;
    private long cacheSerialOfLastRevisionSent = 1L;

    public Watch(long id) {
        this.id = id;
    }

    public Watch(String user, String rep, Path path, WaybackSpec constraint) {
        this(-1L, user, rep, path, constraint);
    }

    public Watch(long id, String user, String rep, Path path, WaybackSpec constraint) {
        this(id, user, rep, path, constraint, -1L, null);
    }

    public Watch(long id, String user, String rep, Path path, WaybackSpec constraint, long lastChecked, RevInfoKey lastRevisionSent) {
        this.id = id;
        this.user = user;
        this.rep = rep;
        this.path = path;
        this.constraint = constraint;
        this.lastChecked = lastChecked;
        this.lastRevisionSent = lastRevisionSent;
    }

    public long getId() {
        return this.id;
    }

    public String getRep() {
        return this.rep;
    }

    public void setRep(String rep) {
        this.rep = rep;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public WaybackSpec getConstraint() {
        return this.constraint;
    }

    public void setConstraint(WaybackSpec constraint) {
        this.constraint = constraint;
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    public void setLastChecked(long lastChecked) {
        this.lastChecked = lastChecked;
    }

    public RevInfoKey getLastRevisionSent() {
        return this.lastRevisionSent;
    }

    public void setLastRevisionSent(RevInfoKey lastRevisionSent) {
        this.lastRevisionSent = lastRevisionSent;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public long getCacheSerialOfLastRevisionSent() {
        return this.cacheSerialOfLastRevisionSent;
    }

    public void setCacheSerialOfLastRevisionSent(long cacheSerialOfLastRevisionSent) {
        this.cacheSerialOfLastRevisionSent = cacheSerialOfLastRevisionSent;
    }

    public boolean isSameEntity(String rep, Path path) {
        return this.rep.equals(rep) && this.path.equals(path);
    }

    public boolean isEquivalent(Watch other) {
        return other.rep.equals(this.rep) && other.path.equals(this.path) && (other.constraint == null && this.constraint == null || other.constraint != null && other.constraint.equals(this.constraint));
    }

    public String toString() {
        return "Watch[id=" + this.id + ";user=" + this.user + ";rep=" + this.rep + ";path=" + this.path + ";constraint=" + this.constraint + ";lastChecked=" + this.lastChecked + ";lastRevisionSent=" + this.lastRevisionSent + ";csn=" + this.cacheSerialOfLastRevisionSent + "]";
    }
}

