/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.FishEyeBackup;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;
import com.cenqua.fisheye.web.admin.actions.HtmlTesterLayout;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;

public class BackupAction
extends BaseRepositoryAction {
    private String backupLocation = "";
    private String backupLog = "";

    public String doDefault() throws Exception {
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        StringWriter writer = new StringWriter();
        Logger anonLogger = Logs.makeAnonymousLogger();
        String ndc = "backup-action-" + System.currentTimeMillis();
        WriterAppender appender = this.addAppLogAppender(writer, ndc, anonLogger);
        try {
            NDC.push((String)ndc);
            FishEyeBackup febu = new FishEyeBackup(anonLogger);
            File backupFile = febu.backup();
            this.backupLocation = backupFile.getCanonicalPath();
        }
        catch (Throwable e2) {
            String msg = "Error performing backup: " + e2.getMessage();
            this.addActionError(msg);
            Logs.APP_LOG.error((Object)msg, e2);
            anonLogger.error((Object)msg, e2);
            String string = "error";
            return string;
        }
        finally {
            this.backupLog = writer.toString();
            anonLogger.removeAppender((Appender)appender);
            NDC.pop();
        }
        return "success";
    }

    private WriterAppender addAppLogAppender(StringWriter writer, String ndc, Logger logger) {
        HtmlTesterLayout layout = new HtmlTesterLayout(new HashMap(), ndc);
        WriterAppender appender = new WriterAppender((Layout)layout, (Writer)writer);
        appender.setThreshold((Priority)Level.ALL);
        appender.setImmediateFlush(true);
        logger.addAppender((Appender)appender);
        return appender;
    }

    public String getBackupLocation() {
        return this.backupLocation;
    }

    public String getBackupLog() {
        return this.backupLog;
    }
}

