/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import com.opensymphony.xwork.ActionSupport;
import java.io.File;
import java.text.SimpleDateFormat;

public class EditLicenseAction
extends ActionSupport {
    private static final String CRU_FIELD = "cruLicense";
    private static final String FE_FIELD = "feLicense";
    private String feLicense;
    private String cruLicense;
    private String feLicenseFilePath;
    private String cruLicenseFilePath;
    private boolean isFeFileLicense;
    private boolean isCruFileLicense;

    public EditLicenseAction() {
        RootConfig rootConfig = AppConfig.getsConfig();
        LicenseType licenseType = rootConfig.getConfig().getLicense();
        if (licenseType.isSetFisheye()) {
            this.feLicense = licenseType.getFisheye();
            this.isFeFileLicense = false;
        } else {
            File feLicenseFile = rootConfig.getLicense().getFisheyeLicense().getLicenseFile();
            if (feLicenseFile != null && feLicenseFile.isFile()) {
                this.feLicenseFilePath = feLicenseFile.getAbsolutePath();
                this.isFeFileLicense = true;
            }
        }
        if (this.isCrucible()) {
            if (licenseType.isSetCrucible()) {
                this.cruLicense = licenseType.getCrucible();
                this.isCruFileLicense = false;
            } else {
                File cruLicenseFile = rootConfig.getLicense().getCrucibleLicense().getLicenseFile();
                if (cruLicenseFile != null && cruLicenseFile.isFile()) {
                    this.cruLicenseFilePath = cruLicenseFile.getAbsolutePath();
                    this.isCruFileLicense = true;
                }
            }
        }
    }

    public String getFeLicense() {
        return this.feLicense;
    }

    public void setFeLicense(String feLicense) {
        this.feLicense = feLicense == null ? null : feLicense.trim();
    }

    public String getCruLicense() {
        return this.cruLicense;
    }

    public void setCruLicense(String cruLicense) {
        this.cruLicense = cruLicense == null ? null : cruLicense.trim();
    }

    public String getFeLicenseFilePath() {
        return this.feLicenseFilePath;
    }

    public boolean isFeFileLicense() {
        return this.isFeFileLicense;
    }

    public String getCruLicenseFilePath() {
        return this.cruLicenseFilePath;
    }

    public boolean isCruFileLicense() {
        return this.isCruFileLicense;
    }

    public void validate() {
        LicenseHolder holder = new LicenseHolder(this.feLicense, this.cruLicense);
        if (!holder.hasFishEye()) {
            if (!this.isFeFileLicense) {
                this.addFieldError(FE_FIELD, "Please enter a FishEye license key.");
            }
        } else if (!holder.canDecodeFishEye()) {
            this.addFieldError(FE_FIELD, "The FishEye license key you have entered is invalid.");
        } else if (holder.isFishEyeTerminated()) {
            this.addFieldError(FE_FIELD, this.terminatedLicenseMessage(holder.getFishEyeLicense().getSoftExpiry()));
        } else if (!holder.isFishEyeValidForCurrentBuild()) {
            this.addFieldError(FE_FIELD, holder.getFishEyeLicense().getInvalidBuildMessage());
        }
        if (this.isCrucible()) {
            if (!holder.hasCrucible()) {
                if (!this.isCruFileLicense) {
                    this.addFieldError(CRU_FIELD, "Please enter a Crucible license key.");
                }
            } else if (!holder.canDecodeCrucible()) {
                this.addFieldError(CRU_FIELD, "The Crucible license key you have entered is invalid.");
            } else if (holder.isCrucibleTerminated()) {
                this.addFieldError(CRU_FIELD, this.terminatedLicenseMessage(holder.getCrucibleLicense().getSoftExpiry()));
            } else if (!holder.isCrucibleValidForCurrentBuild()) {
                this.addFieldError(CRU_FIELD, holder.getCrucibleLicense().getInvalidBuildMessage());
            }
        }
    }

    public String execute() throws Exception {
        RootConfig rootConfig = AppConfig.getsConfig();
        LicenseType licenses = rootConfig.getConfig().getLicense();
        boolean licensesUpdated = false;
        if (!(StringUtil.nullOrEmpty(this.feLicense) || licenses.isSetFisheye() && licenses.getFisheye().equals(this.feLicense))) {
            licenses.setFisheye(this.feLicense);
            licensesUpdated = true;
        }
        if (!(!this.isCrucible() || StringUtil.nullOrEmpty(this.cruLicense) || licenses.isSetCrucible() && licenses.getCrucible().equals(this.cruLicense))) {
            licenses.setCrucible(this.cruLicense);
            licensesUpdated = true;
        }
        if (licensesUpdated) {
            try {
                rootConfig.saveConfig();
                rootConfig.refreshLicenses();
            }
            catch (LicenseException e2) {
                Logs.APP_LOG.warn((Object)("Failed to reload licenses: " + e2.getMessage()));
                this.addFieldError("license", "There was a problem updating your licenses. See log for details.");
                return "input";
            }
        }
        return "success";
    }

    private boolean isCrucible() {
        return AppConfig.isCrucible();
    }

    private String terminatedLicenseMessage(long expiredMs) {
        return "The license key you have entered terminated on " + new SimpleDateFormat("MMMM dd, yyyy").format(expiredMs) + ". Please enter a current license key.";
    }
}

