/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public class EditTarballExcludeAction
extends BaseRepositoryAction {
    private boolean subdirs;
    private String basedir;

    public boolean isSubdirs() {
        return this.subdirs;
    }

    public void setSubdirs(boolean subdirs) {
        this.subdirs = subdirs;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        TarballType.Exclude saving = TarballType.Exclude.Factory.newInstance();
        if (this.subdirs) {
            saving.setTree(this.basedir);
        } else {
            saving.setDir(this.basedir);
        }
        try {
            TarballType tarball;
            if (this.isDefault()) {
                tarball = cfg.getRepositoryDefaults().getTarball();
            } else {
                try {
                    RepositoryType repository = cfg.getRepositoryArray(this.getRep());
                    tarball = repository.getTarball();
                }
                catch (IndexOutOfBoundsException e2) {
                    this.addActionError("Bad repository index " + this.getRep());
                    return "error";
                }
            }
            tarball.setExcludeArray(this.getIdx(), saving);
        }
        catch (IndexOutOfBoundsException e3) {
            this.addActionError("Bad tarball exclude index " + this.getIdx() + ", rep=" + this.getRep());
            return "error";
        }
        this.saveCfg();
        return "success";
    }

    public String doDefault() throws Exception {
        TarballType.Exclude editing;
        block8: {
            editing = null;
            ConfigDocument.Config cfg = this.getCfg();
            try {
                if (this.isDefault()) {
                    editing = cfg.getRepositoryDefaults().getTarball().getExcludeArray(this.getIdx());
                    break block8;
                }
                try {
                    RepositoryType repository = cfg.getRepositoryArray(this.getRep());
                    editing = repository.getTarball().getExcludeArray(this.getIdx());
                }
                catch (IndexOutOfBoundsException e2) {
                    this.addActionError("Bad repository index " + this.getRep());
                    return "error";
                }
            }
            catch (IndexOutOfBoundsException e3) {
                this.addActionError("Bad tarball exclude index " + this.getIdx() + ", rep=" + this.getRep());
                return "error";
            }
        }
        if (editing.isSetTree()) {
            this.subdirs = true;
            this.basedir = editing.getTree();
        } else if (editing.isSetDir()) {
            this.subdirs = false;
            this.basedir = editing.getDir();
        }
        return "success";
    }
}

