/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.PingManager;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.rep.ping.RescanRequest;
import com.cenqua.fisheye.svn.SvnRepositoryEngine;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;
import java.util.List;

public class IndexMaintainanceAction
extends BaseRepositoryAction {
    private String action;
    private long startRev;
    private long endRev;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean isFullscan() {
        return "fullscan".equals(this.action);
    }

    public boolean isReindex() {
        return "reindex".equals(this.action);
    }

    public boolean isReindexCrucible() {
        return "reindexcru".equals(this.action);
    }

    public boolean isReindexLinecount() {
        return "reindexlinecount".equals(this.action);
    }

    public boolean isRevPropRescan() {
        return "rescan".equals(this.action);
    }

    private boolean isScanNow() {
        return "scannow".equals(this.action);
    }

    public long getStartRev() {
        return this.startRev;
    }

    public void setStartRev(long startRev) {
        this.startRev = startRev;
    }

    public long getEndRev() {
        return this.endRev;
    }

    public void setEndRev(long endRev) {
        this.endRev = endRev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        RepositoryHandle rh = this.getRepositoryHandle();
        if (rh == null) {
            this.addActionError("Bad repository index " + this.getRep());
            return "error";
        }
        Disposer.pushThreadInstance();
        String result = "error";
        try {
            if (this.isFullscan()) {
                RepositoryEngine re = rh.acquireEngine();
                re.requestFullscan();
                this.addActionMessage("Full scan requested for repository: " + rh.getName());
                result = "success";
            } else if (this.isReindex()) {
                this.reindex(rh);
                this.addActionMessage("Reindex requested for repository: " + rh.getName());
                result = "success";
            } else if (this.isReindexCrucible()) {
                Logs.APP_LOG.debug((Object)("Requesting Crucible reindex for " + rh.getName()));
                rh.requestCrucibleReindex();
                this.addActionMessage("Crucible reindex requested for repository: " + rh.getName());
                result = "success";
            } else if (this.isRevPropRescan()) {
                result = this.rescan() ? "success" : "error";
            } else if (this.isScanNow()) {
                this.addActionMessage("Commencing repository scan: " + rh.getName());
                rh.oneOffScan(false);
            } else if (this.isReindexLinecount()) {
                this.addActionMessage("Linecount reindex requested for repository: " + rh.getName());
                Logs.APP_LOG.debug((Object)("Requesting linecount reindex for " + rh.getName()));
                rh.requestLinecountReindex();
            }
        }
        catch (RepositoryHandle.StateException e2) {
            this.addActionError("Repository must be running in order to perform this action.");
            result = "error";
        }
        finally {
            Disposer.popThreadInstance();
        }
        this.updateRescanInfo();
        return result;
    }

    private boolean rescan() throws RepositoryHandle.StateException {
        boolean result = true;
        try {
            RepositoryHandle rh = this.getRepositoryHandle();
            rh.rescan(Long.toString(this.startRev), Long.toString(this.endRev));
            this.addActionMessage("Rescan scheduled");
        }
        catch (IllegalStateException e2) {
            result = false;
            Logs.APP_LOG.debug((Object)"Unable to schedule rescan", (Throwable)e2);
            this.addActionError("Unable to schedule rescan: " + e2.getMessage());
        }
        return result;
    }

    private void reindex(RepositoryHandle rh) {
        boolean wasRunning = rh.isRunning();
        if (!rh.tryStop(20000L)) {
            this.addActionError("Could not stop repository within 20 seconds. Re-index aborted.");
            return;
        }
        try {
            rh.deleteIndex();
        }
        catch (RepositoryHandle.StateException e2) {
            this.addActionError("Could not delete cache: " + e2.getMessage());
            Logs.APP_LOG.warn((Object)"problem deleting cache", (Throwable)e2);
        }
        if (wasRunning) {
            try {
                AppConfig.getsConfig().getRepositoryManager().runRepository(rh.getName());
            }
            catch (Exception e3) {
                this.addActionError("Could not restart repository: " + e3.getMessage());
                Logs.APP_LOG.warn((Object)"problem restarting repos", (Throwable)e3);
            }
        }
    }

    public String doDefault() {
        this.updateRescanInfo();
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRescanInfo() {
        Disposer.pushThreadInstance();
        try {
            RepositoryEngine re;
            RepositoryHandle rh = this.getRepositoryHandle();
            if (rh.isRunning() && (re = rh.acquireEngine()) instanceof SvnRepositoryEngine) {
                SvnRepositoryEngine sre = (SvnRepositoryEngine)re;
                this.endRev = sre.getScanner().getSvnCache().getPhase1Revision();
                this.startRev = Math.max(0L, this.endRev - 100L);
                this.notifyPendingRequests(rh);
            }
        }
        catch (Exception e2) {
            this.endRev = 0L;
            this.startRev = 0L;
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private void notifyPendingRequests(RepositoryHandle rh) {
        List<PingRequest> requests = PingManager.getPendingRequests(rh);
        for (PingRequest request : requests) {
            if (!(request instanceof RescanRequest)) continue;
            this.addActionMessage(request.getDescription());
        }
    }
}

