/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.PolledUpdaterType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.MD5;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;
import com.cenqua.fisheye.web.admin.actions.HtmlTesterLayout;
import com.cenqua.fisheye.web.admin.actions.ImportTypeHelper;
import com.cenqua.fisheye.web.admin.actions.svn.SvnSymbolicHelper;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;

public class ViewRepositoryAction
extends BaseRepositoryAction {
    private static final String SUCCESS_DEFAULT = "success_default";
    protected RepositoryType repository;
    private SvnSymbolicHelper svnSymbolic = new SvnSymbolicHelper();
    private ImportTypeHelper importType = new ImportTypeHelper();
    private String verifyLog = null;
    private boolean verifySuccess = true;

    public String getVerifyLog() throws Exception {
        return this.verifyLog;
    }

    public boolean isVerifySuccess() {
        return this.verifySuccess;
    }

    public RepositoryType getRepository() {
        return this.repository;
    }

    public SvnSymbolicHelper getSvnSymbolic() {
        return this.svnSymbolic;
    }

    public PolledUpdaterType getPolledUpdater() {
        RepositoryType repository = this.getRepository();
        if (repository.isSetSvn()) {
            return repository.getSvn().getUpdater();
        }
        if (repository.isSetPerforce()) {
            return repository.getPerforce().getUpdater();
        }
        return null;
    }

    public String getSvnImportType() {
        String key = this.repository.getSvn().getInitialImport();
        if (key == null) {
            key = "none";
        }
        return (String)ImportTypeHelper.IMPORT_TYPES.get(key);
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        if (this.isDefault()) {
            return SUCCESS_DEFAULT;
        }
        try {
            this.loadRepo(cfg);
        }
        catch (IndexOutOfBoundsException e2) {
            this.addActionError("Bad repository index " + this.getRep());
            return "error";
        }
        return "success";
    }

    private void loadRepo(ConfigDocument.Config cfg) {
        this.repository = cfg.getRepositoryArray(this.getRep());
        if (this.repository.isSetSvn()) {
            this.svnSymbolic.setup(this.repository.getSvn());
        }
        if (this.repository.isSetCvs()) {
            this.repository.setStoreDiff(true);
        }
    }

    public String getAccessMD5() {
        SvnRepType svn = this.repository.getSvn();
        return svn != null ? "md5:" + MD5.hash(svn.getAccess()) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doVerify() throws Exception {
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        this.loadRepo(cfg);
        String ndc = "verify-svn-" + System.currentTimeMillis();
        HtmlTesterLayout layout = new HtmlTesterLayout(HtmlTesterLayout.getDefaultStyle(), ndc);
        StringWriter writer = new StringWriter();
        WriterAppender appender = new WriterAppender((Layout)layout, (Writer)writer);
        appender.setThreshold((Priority)Level.ALL);
        appender.setImmediateFlush(true);
        try {
            Logs.APP_LOG.addAppender((Appender)appender);
            NDC.push((String)ndc);
            AppConfig.getsConfig().getRepositoryManager().testConnection(this.repository.getName());
            Logs.APP_LOG.info((Object)"Connection success.");
            this.verifySuccess = true;
            String string = "success";
            return string;
        }
        catch (IndexOutOfBoundsException e2) {
            this.addActionError("Bad repository index " + this.getRep());
            Logs.APP_LOG.error((Object)"Connection failure.");
        }
        catch (Throwable e3) {
            Logs.APP_LOG.error((Object)"Error testing connection.", e3);
            Logs.APP_LOG.error((Object)"Connection failure.");
        }
        finally {
            Logs.APP_LOG.removeAppender((Appender)appender);
            NDC.pop();
            this.verifyLog = writer.toString();
            this.repository = this.getCfg().getRepositoryArray(this.getRep());
        }
        this.verifySuccess = false;
        return "error";
    }
}

