/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.plugins;

import com.atlassian.fisheye.plugin.FisheyePluginManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewPluginsAction
extends BaseAdminAction {
    private Collection<PluginData> plugins;
    private PluginAccessor pluginAccessor;
    private boolean reload = false;
    private Collection<PluginData> previousPlugins;
    private PluginController pluginController;
    private static final String PLUGIN = "plugin";
    private static final String MODULE = "module";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private String key;
    private String type;
    private String action;

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setPluginController(PluginController pluginController) {
        this.pluginController = pluginController;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAction(String action) {
        this.action = action;
    }

    private String getActionParameters(String key, String type, String state) {
        String action;
        if (state.equals("Enabled")) {
            action = DISABLE;
        } else if (state.equals("Disabled")) {
            action = ENABLE;
        } else {
            return null;
        }
        return "key=" + key + "&type=" + type + "&action=" + action;
    }

    private String getActionName(String state) {
        return state.equals("Enabled") ? "Disable" : (state.equals("Disabled") ? "Enable" : null);
    }

    public String execute() throws Exception {
        if (this.reload) {
            this.previousPlugins = this.getPluginData(null);
            int newPluginsFound = this.pluginController.scanForNewPlugins();
            if (newPluginsFound > 0) {
                this.addActionMessage("Found " + newPluginsFound + " new plugins");
            } else {
                this.addActionMessage("No new plugins found.");
            }
        }
        if (this.key != null) {
            this.doAnAction(this.key, this.type, this.action);
        }
        return super.execute();
    }

    private void doAnAction(String key, String type, String action) {
        if (type.equals(PLUGIN)) {
            if (action.equals(ENABLE)) {
                this.pluginController.enablePlugin(key);
            } else if (action.equals(DISABLE)) {
                this.pluginController.disablePlugin(key);
            }
        } else if (type.equals(MODULE)) {
            if (action.equals(ENABLE)) {
                this.pluginController.enablePluginModule(key);
            } else if (action.equals(DISABLE)) {
                this.pluginController.disablePluginModule(key);
            }
        }
    }

    public Collection<PluginData> getPlugins() {
        if (this.plugins == null) {
            this.plugins = this.getPluginData(this.previousPlugins);
        }
        return Collections.unmodifiableCollection(this.plugins);
    }

    private Collection<PluginData> getPluginData(Collection<PluginData> previous) {
        ArrayList<PluginData> plugins = new ArrayList<PluginData>();
        for (Plugin p : this.getPluginAccessor().getPlugins()) {
            plugins.add(new PluginData(p, this.getPluginAccessor(), previous, this.key));
        }
        return plugins;
    }

    public String getPluginDirectoryPath() {
        try {
            return FisheyePluginManager.getPluginDirectory().getCanonicalPath();
        }
        catch (IOException e2) {
            return "Invalid Path";
        }
    }

    private PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public class PluginModuleData {
        private String key;
        private String name;
        private String description;
        private String state;
        private String errorMessage;

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getState() {
            return this.state;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getActionParameters() {
            return ViewPluginsAction.this.getActionParameters(this.key, ViewPluginsAction.MODULE, this.state);
        }

        public String getActionName() {
            return ViewPluginsAction.this.getActionName(this.state);
        }

        public PluginModuleData(String key, String name, String description, String state, String errorMessage) {
            this.key = key;
            this.name = name;
            if (StringUtil.nullOrEmpty(name)) {
                this.name = key;
            }
            this.description = description;
            this.state = state;
            this.errorMessage = errorMessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PluginData {
        private String name;
        private String key;
        private String description;
        private String state;
        private String errorMessage;
        private List<PluginModuleData> modules = new ArrayList<PluginModuleData>();
        private boolean newlyFound = false;
        private boolean highlighted = false;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginData that = (PluginData)o;
            return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }

        public PluginData(Plugin plugin, PluginAccessor pluginAccessor, Collection<PluginData> previousPlugins, String highlightKey) {
            this.name = plugin.getName();
            this.key = plugin.getKey();
            if (StringUtil.nullOrEmpty(this.name)) {
                this.name = this.key;
            }
            this.description = plugin.getPluginInformation().getDescription();
            boolean hasError = plugin instanceof UnloadablePlugin;
            this.state = hasError ? "Error" : (pluginAccessor.isPluginEnabled(plugin.getKey()) ? "Enabled" : "Disabled");
            this.errorMessage = hasError ? ((UnloadablePlugin)plugin).getErrorText() : "";
            this.newlyFound = previousPlugins != null && !previousPlugins.contains(this);
            this.highlighted = highlightKey != null && this.key.equals(highlightKey);
            boolean allModulesEnabled = true;
            boolean allModulesDisabled = true;
            for (ModuleDescriptor m : plugin.getModuleDescriptors()) {
                boolean moduleEnabled;
                boolean moduleHasError = false;
                String errorText = "";
                if (m instanceof UnloadableModuleDescriptor) {
                    errorText = ((UnloadableModuleDescriptor)m).getErrorText();
                    moduleHasError = true;
                }
                if (m instanceof UnrecognisedModuleDescriptor) {
                    errorText = ((UnrecognisedModuleDescriptor)m).getErrorText();
                    moduleHasError = true;
                }
                if (moduleEnabled = pluginAccessor.isPluginModuleEnabled(m.getCompleteKey())) {
                    allModulesDisabled = false;
                } else {
                    allModulesEnabled = false;
                }
                this.modules.add(new PluginModuleData(m.getCompleteKey(), m.getName(), m.getDescription(), moduleHasError ? "Error" : (moduleEnabled ? "Enabled" : "Disabled"), errorText));
            }
            this.modules = Collections.unmodifiableList(this.modules);
            if (!hasError) {
                this.errorMessage = "Some modules disabled.";
                if (allModulesDisabled) {
                    this.errorMessage = "All modules disabled.";
                } else if (allModulesEnabled) {
                    this.errorMessage = "All modules enabled.";
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String getState() {
            return this.state;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public Collection<PluginModuleData> getModules() {
            return this.modules;
        }

        public boolean isNewlyFound() {
            return this.newlyFound;
        }

        public String getActionParameters() {
            return ViewPluginsAction.this.getActionParameters(this.key, ViewPluginsAction.PLUGIN, this.state);
        }

        public String getActionName() {
            return ViewPluginsAction.this.getActionName(this.state);
        }
    }
}

